/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.dependency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakDependencyMap<T> {
    private final Map<T, Set<T>> dependers = new WeakHashMap<T, Set<T>>();

    public void addDependency(T dependee, T depender) {
        this.dependers.computeIfAbsent(dependee, dummy -> this.createSet()).add(depender);
    }

    public Collection<T> getTransitiveClosure(Collection<T> seeds) {
        return new ClosureComputer().addAll(seeds).getClosure();
    }

    private Set<T> createSet() {
        return Collections.newSetFromMap(new WeakHashMap());
    }

    private class ClosureComputer {
        private final Set<T> closure = new HashSet();

        public ClosureComputer add(T dependee) {
            if (this.closure.add(dependee)) {
                WeakDependencyMap.this.dependers.getOrDefault(dependee, Collections.emptySet()).forEach(this::add);
            }
            return this;
        }

        public ClosureComputer addAll(Collection<T> dependees) {
            dependees.forEach(this::add);
            return this;
        }

        public Set<T> getClosure() {
            return this.closure;
        }
    }
}

