/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.integer;

import com.softicar.platform.common.core.annotations.Nullable;
import com.softicar.platform.common.core.logging.Log;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractIntKeySet<V> {
    protected static final int MIN_CAPACITY = 4;
    private static final int DEFAULT_MAX_LOAD_PERCENTAGE = 75;
    private final int maxLoadPercentage;
    private int _size = 0;

    public AbstractIntKeySet() {
        this(75);
    }

    public AbstractIntKeySet(int maxLoadPercentage) {
        this.maxLoadPercentage = maxLoadPercentage;
    }

    protected final V _add(V value) {
        int index = this.findSlot(this.getKey(value));
        V oldValue = this.getValue(index);
        if (oldValue != null) {
            this.setValue(index, value);
        } else {
            if (this.needGrow(this._size + 1)) {
                this.rebuild(2 * this.getCapacity());
                index = this.findSlot(this.getKey(value));
            }
            ++this._size;
            this.setValue(index, value);
        }
        return oldValue;
    }

    protected final V _get(int key) {
        int index = this.findSlot(key);
        return this.getValue(index);
    }

    protected final V _remove(int key) {
        int i = this.findSlot(key);
        V removedValue = this.getValue(i);
        if (removedValue != null) {
            if (this.needShrink(this._size - 1)) {
                this.setValue(i, null);
                this.rebuild(this.getCapacity() / 2);
            } else {
                V value;
                int j = i;
                while ((value = this.getValue(j = j + 1 & this.getCapacity() - 1)) != null) {
                    int k = this.getPrimarySlot(this.getKey(value));
                    if ((j <= i || k > i && k <= j) && (j >= i || k > i || k <= j)) continue;
                    this.setValue(i, value);
                    i = j;
                }
                this.setValue(i, null);
                --this._size;
            }
        }
        return removedValue;
    }

    protected final double _getStepAverage() {
        int totalDistance = 0;
        Iterator<V> iterator = this._iterator();
        while (iterator.hasNext()) {
            int key = this.getKey(iterator.next());
            int primary = this.getPrimarySlot(key);
            int slot = this.findSlot(key);
            int distance = slot - primary;
            if (distance < 0) {
                distance += this.getCapacity();
            }
            totalDistance += distance;
        }
        return this._size > 0 ? (double)totalDistance / (double)this._size : 0.0;
    }

    protected final double _getClusterAverage() {
        int totalClusterSize = 0;
        int clusterCount = 0;
        int clusterSize = 0;
        for (int i = 0; i < this.getCapacity(); ++i) {
            if (this.getValue(i) == null) {
                if (clusterSize > 0) {
                    totalClusterSize += clusterSize;
                    ++clusterCount;
                }
                clusterSize = 0;
                continue;
            }
            ++clusterSize;
        }
        if (clusterSize > 0) {
            totalClusterSize += clusterSize;
            ++clusterCount;
        }
        return (double)totalClusterSize / (double)clusterCount;
    }

    protected final int _size() {
        return this._size;
    }

    protected final String _toString() {
        int i = 0;
        StringBuilder builder = new StringBuilder("[");
        for (V value : this.getValues()) {
            if (value == null) continue;
            builder.append(this.getKey(value)).append(": " + value);
            if (++i >= this._size) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    protected final Iterator<V> _iterator() {
        return new Iter();
    }

    protected abstract int getKey(V var1);

    protected abstract void setValue(int var1, @Nullable V var2);

    protected abstract V getValue(int var1);

    protected abstract List<V> getValues();

    protected abstract int getCapacity();

    protected abstract void resize(int var1);

    private final int findSlot(int key) {
        assert (this._size < this.getCapacity());
        int index = this.getPrimarySlot(key);
        V value;
        while ((value = this.getValue(index)) != null) {
            if (this.getKey(value) == key) {
                return index;
            }
            index = index + 1 & this.getCapacity() - 1;
        }
        return index;
    }

    private final int getPrimarySlot(int key) {
        return AbstractIntKeySet.getHash(key) & this.getCapacity() - 1;
    }

    private final boolean needGrow(int newSize) {
        int capacity = this.getCapacity();
        return (long)newSize * 100L / (long)capacity > (long)this.maxLoadPercentage || newSize >= capacity;
    }

    private final boolean needShrink(int newSize) {
        int capacity = this.getCapacity();
        return (long)newSize * 100L / (long)(capacity / 4) <= (long)this.maxLoadPercentage && capacity > 4;
    }

    private final void rebuild(int newCapacity) {
        int oldCapacity = this.getCapacity();
        List<V> oldValues = this.getValues();
        this.resize(newCapacity);
        this._size = 0;
        for (Object value : oldValues) {
            if (value == null) continue;
            this._add(value);
        }
        Log.fverbose((String)"WeakIntHashMap rebuilded: size: %s capacity: %s->%s", (Object[])new Object[]{this._size, oldCapacity, this.getCapacity()});
    }

    private static int getHash(int hash) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result += hash >> i * 8 & 0xFF;
            result += result << 10;
            result ^= result >> 6;
        }
        result += result << 3;
        result ^= result >> 11;
        result += result << 15;
        return result;
    }

    private final class Iter
    implements Iterator<V> {
        private int _index = -1;

        public Iter() {
            this.findNext();
        }

        @Override
        public final boolean hasNext() {
            return this._index < AbstractIntKeySet.this.getCapacity();
        }

        @Override
        public final V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = AbstractIntKeySet.this.getValue(this._index);
            this.findNext();
            return value;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        private final void findNext() {
            ++this._index;
            while (this._index < AbstractIntKeySet.this.getCapacity() && AbstractIntKeySet.this.getValue(this._index) == null) {
                ++this._index;
            }
        }
    }
}

