/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.list;

import com.softicar.platform.common.container.map.list.IListMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractListMap<K, V>
implements IListMap<K, V> {
    private final Map<K, List<V>> lists;

    public AbstractListMap(Map<K, List<V>> lists) {
        this.lists = lists;
    }

    @Override
    public boolean containsKey(K key) {
        return this.lists.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.lists.isEmpty();
    }

    @Override
    public int size() {
        return this.lists.size();
    }

    @Override
    public Set<K> keySet() {
        return this.lists.keySet();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.lists.entrySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.lists.values();
    }

    @Override
    public List<V> getList(K key) {
        List<V> list = this.lists.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.lists.put(key, list);
        }
        return list;
    }

    @Override
    public List<V> getListsContent() {
        ArrayList<V> contentList = new ArrayList<V>();
        for (List<V> list : this.values()) {
            for (V v : list) {
                contentList.add(v);
            }
        }
        return contentList;
    }

    @Override
    public void clear() {
        this.lists.clear();
    }

    @Override
    public List<V> removeKey(K key) {
        if (key == null) {
            return null;
        }
        List<V> result = this.lists.get(key);
        this.lists.remove(key);
        return result;
    }

    @Override
    public void addToList(K key, V value) {
        List<V> list = this.lists.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.lists.put(key, list);
        }
        list.add(value);
    }

    @Override
    public void addAllToList(K key, Collection<V> values) {
        List<V> list = this.lists.get(key);
        if (list == null) {
            this.lists.put(key, new ArrayList<V>(values));
        } else {
            list.addAll(values);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractListMap) {
            return Objects.equals(this.lists, ((AbstractListMap)object).lists);
        }
        return false;
    }

    public int hashCode() {
        return this.lists.hashCode();
    }

    public String toString() {
        Object result = "";
        int maxLength = 0;
        for (K k : this.keySet()) {
            maxLength = Math.max(k.toString().length() + ("(h:" + k.hashCode() + ")").length(), maxLength);
        }
        for (K k : this.keySet()) {
            Object line = k.toString();
            while (((String)line).length() < maxLength) {
                line = (String)line + " ";
            }
            line = (String)line + "(h:" + k.hashCode() + ")";
            line = (String)line + ":";
            if (this.getList(k).size() == 0) {
                result = (String)result + (String)line + " empty\n";
                continue;
            }
            for (V v : this.getList(k)) {
                while (((String)line).length() < maxLength + 2) {
                    line = (String)line + " ";
                }
                line = (String)line + v.toString() + "(hash: " + v.hashCode() + ")\n";
                result = (String)result + (String)line;
                line = "";
            }
        }
        return result;
    }
}

