/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.map;

import com.softicar.platform.common.container.map.map.IMapMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

class MapMap<K1, K2, V>
implements IMapMap<K1, K2, V> {
    private final Map<K1, Map<K2, V>> mapMap;
    private final Supplier<Map<K2, V>> mapFactory;

    public MapMap(Map<K1, Map<K2, V>> mapMap, Supplier<Map<K2, V>> mapFactory) {
        this.mapMap = mapMap;
        this.mapFactory = mapFactory;
    }

    @Override
    public void clear() {
        this.mapMap.clear();
    }

    @Override
    public boolean contains(K1 primaryKey, K2 secondaryKey) {
        return this.getMap(primaryKey).containsKey(secondaryKey);
    }

    @Override
    public boolean containsKey(K1 primaryKey) {
        return this.mapMap.containsKey(primaryKey);
    }

    @Override
    public Set<Map.Entry<K1, Map<K2, V>>> entrySet() {
        return this.mapMap.entrySet();
    }

    public boolean equals(Object object) {
        if (object instanceof MapMap) {
            return this.mapMap.equals(((MapMap)object).mapMap);
        }
        return false;
    }

    @Override
    public V get(K1 primaryKey, K2 secondaryKey) {
        return this.getMap(primaryKey).get(secondaryKey);
    }

    @Override
    public Map<K2, V> getMap(K1 primaryKey) {
        Map<K2, V> map = this.mapMap.get(primaryKey);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public int hashCode() {
        return this.mapMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.mapMap.isEmpty();
    }

    @Override
    public Set<K1> keySet() {
        return this.mapMap.keySet();
    }

    @Override
    public V put(K1 primaryKey, K2 secondaryKey, V value) {
        Map<K2, V> map = this.mapMap.get(primaryKey);
        if (map == null) {
            map = this.mapFactory.get();
            this.mapMap.put(primaryKey, map);
        }
        return map.put(secondaryKey, value);
    }

    @Override
    public void putAll(IMapMap<K1, K2, V> mapMap) {
        for (Map.Entry<K1, Map<K2, V>> mapEntry : mapMap.entrySet()) {
            for (Map.Entry<K2, V> valueEntry : mapEntry.getValue().entrySet()) {
                this.put(mapEntry.getKey(), valueEntry.getKey(), valueEntry.getValue());
            }
        }
    }

    @Override
    public void remove(K1 primaryKey) {
        this.mapMap.remove(primaryKey);
    }

    @Override
    public V remove(K1 primaryKey, K2 secondaryKey) {
        Map<K2, V> map = this.mapMap.get(primaryKey);
        if (map != null) {
            V value = map.remove(secondaryKey);
            if (map.isEmpty()) {
                this.mapMap.remove(primaryKey);
            }
            return value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.mapMap.size();
    }

    public String toString() {
        return this.mapMap.toString();
    }
}

