/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.number;

import com.softicar.platform.common.container.map.number.INumberMap;
import com.softicar.platform.common.math.arithmetic.IArithmetic;
import com.softicar.platform.common.string.Imploder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class NumberMap<K, V extends Comparable<V>>
implements INumberMap<K, V> {
    private final Map<K, V> data;
    private final IArithmetic<V> arithmetic;

    public NumberMap(IArithmetic<V> arithmetic) {
        this(new TreeMap(), arithmetic);
    }

    public NumberMap(Map<K, V> data, IArithmetic<V> arithmetic) {
        this.data = data;
        this.arithmetic = arithmetic;
    }

    @Override
    public Map<K, V> getDataContainer() {
        return this.data;
    }

    @Override
    public IArithmetic<V> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public boolean containsKey(K key) {
        return this.data.containsKey(key);
    }

    @Override
    public V get(K key) {
        return (V)this.getOrZero((Object)key);
    }

    @Override
    public V getOrZero(K key) {
        Comparable value = (Comparable)this.data.get(key);
        return (V)(value != null ? value : (Comparable)this.arithmetic.getZero());
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        Comparable value = (Comparable)this.data.get(key);
        return (V)(value != null ? value : defaultValue);
    }

    @Override
    public V getOrNull(K key) {
        return (V)((Comparable)this.data.get(key));
    }

    @Override
    public V getOrThrow(K key) {
        Comparable value = (Comparable)this.data.get(key);
        if (value != null) {
            return (V)value;
        }
        throw new RuntimeException(String.format("No matching value for key %s.", key));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.data.values();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void put(K key, V value) {
        if (value == null || value.compareTo((Comparable)((Comparable)this.arithmetic.getZero())) == 0) {
            this.data.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    @Override
    public void putAll(Map<K, V> map) {
        map.entrySet().forEach(entry -> this.put((K)entry.getKey(), (V)((Comparable)entry.getValue())));
    }

    @Override
    public void putAll(INumberMap<K, V> map) {
        map.entrySet().forEach(entry -> this.put((K)entry.getKey(), (V)((Comparable)entry.getValue())));
    }

    @Override
    public V remove(K key) {
        return (V)((Comparable)this.data.remove(key));
    }

    @Override
    public void add(K key, V value) {
        this.put(key, (V)((Comparable)this.arithmetic.plus(this.get((Object)key), value)));
    }

    @Override
    public void sub(K key, V value) {
        this.put(key, (V)((Comparable)this.arithmetic.minus(this.get((Object)key), value)));
    }

    @Override
    public void add(INumberMap<K, V> other) {
        for (K key : other.keySet()) {
            this.add(key, (V)((Comparable)other.get(key)));
        }
    }

    @Override
    public void sub(INumberMap<K, V> other) {
        for (K key : other.keySet()) {
            this.sub(key, (V)((Comparable)other.get(key)));
        }
    }

    @Override
    public void inc(K key) {
        this.add(key, (V)((Comparable)this.arithmetic.getOne()));
    }

    @Override
    public void dec(K key) {
        this.sub(key, (V)((Comparable)this.arithmetic.getOne()));
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof NumberMap) {
            NumberMap other = (NumberMap)otherObject;
            return Objects.equals(this.data, other.data) && Objects.equals(this.arithmetic, other.arithmetic);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.arithmetic);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<K, V> entry : this.data.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return sb.toString();
    }

    public String toStringLine() {
        ArrayList<CallSite> entries = new ArrayList<CallSite>(this.data.size());
        for (Map.Entry<K, V> entry : this.data.entrySet()) {
            entries.add((CallSite)((Object)(entry.getKey() + ": " + entry.getValue())));
        }
        return "[" + Imploder.implode(entries, (String)", ") + "]";
    }
}

