/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.set;

import com.softicar.platform.common.container.map.set.ISetMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SetMap<K extends Comparable<?>, V extends Comparable<? super V>>
implements ISetMap<K, V> {
    private final Map<K, TreeSet<V>> setMap;

    public SetMap() {
        this.setMap = new TreeMap<K, TreeSet<V>>();
    }

    public SetMap(Comparator<K> comparator) {
        this.setMap = new TreeMap<K, TreeSet<V>>(comparator);
    }

    @Override
    public void addAllToSet(K key, Collection<V> values) {
        TreeSet<Object> set = this.setMap.get(key);
        if (set == null) {
            set = new TreeSet();
            this.setMap.put(key, set);
        }
        set.addAll(values);
    }

    @Override
    public boolean addToSet(K key, V value) {
        TreeSet<Object> set = this.setMap.get(key);
        if (set == null) {
            set = new TreeSet();
            this.setMap.put(key, set);
        }
        return set.add(value);
    }

    @Override
    public void clear() {
        this.setMap.clear();
    }

    @Override
    public boolean contains(K key, V value) {
        TreeSet<V> set = this.setMap.get(key);
        return set != null && set.contains(value);
    }

    @Override
    public boolean containsKey(K key) {
        return this.setMap.containsKey(key);
    }

    public Set<Map.Entry<K, TreeSet<V>>> entrySet() {
        return this.setMap.entrySet();
    }

    public boolean equals(Object object) {
        if (object instanceof SetMap) {
            return ((SetMap)object).setMap.equals(this.setMap);
        }
        return false;
    }

    @Override
    public TreeSet<V> getSet(K key) {
        TreeSet<Object> set = this.setMap.get(key);
        if (set == null) {
            set = new TreeSet();
            this.setMap.put(key, set);
        }
        return set;
    }

    @Override
    public Collection<Set<V>> getSets() {
        return Collections.unmodifiableCollection(this.setMap.values());
    }

    public Set<V> getSetsContent() {
        TreeSet<Comparable> contentOfAllSets = new TreeSet<Comparable>();
        for (TreeSet<V> set : this.setMap.values()) {
            for (Comparable v : set) {
                contentOfAllSets.add(v);
            }
        }
        return contentOfAllSets;
    }

    public int hashCode() {
        return this.setMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.setMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.setMap.keySet();
    }

    @Override
    public void remove(K key) {
        this.setMap.remove(key);
    }

    @Override
    public boolean remove(K key, V value) {
        TreeSet<V> set = this.setMap.get(key);
        return set != null && set.remove(value);
    }

    @Override
    public int size() {
        return this.setMap.size();
    }

    public String toString() {
        return this.setMap.toString();
    }
}

