/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.set;

import com.softicar.platform.common.container.map.list.ListTreeMap;
import com.softicar.platform.common.container.map.set.SetMap;
import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class SetMaps {
    public static <S extends Comparable<?>, T extends Comparable<T>> Map<T, S> toInvertedMap(SetMap<S, T> input, boolean allowCollisions) {
        TreeMap<Comparable, Comparable> output = new TreeMap<Comparable, Comparable>();
        for (Map.Entry<S, TreeSet<T>> entry : input.entrySet()) {
            Comparable inputKey = (Comparable)entry.getKey();
            for (Comparable inputValue : entry.getValue()) {
                if (allowCollisions || !output.containsKey(inputValue)) {
                    output.put(inputValue, inputKey);
                    continue;
                }
                throw new SofticarDeveloperException("Collision detected while inverting a %s (in collision-free mode).", new Object[]{SetMap.class.getSimpleName()});
            }
        }
        return output;
    }

    public static <S extends Comparable<? super S>, T extends Comparable<T>> SetMap<T, S> toInvertedSetMap(SetMap<S, T> input) {
        SetMap<Comparable, Comparable> output = new SetMap<Comparable, Comparable>();
        for (Map.Entry<S, TreeSet<T>> entry : input.entrySet()) {
            Comparable inputKey = (Comparable)entry.getKey();
            for (Comparable inputValue : entry.getValue()) {
                output.addToSet(inputValue, inputKey);
            }
        }
        return output;
    }

    public static <S extends Comparable<?>, T extends Comparable<T>> ListTreeMap<T, S> toListMap(SetMap<S, T> input) {
        ListTreeMap<Comparable, Comparable> output = new ListTreeMap<Comparable, Comparable>();
        for (Map.Entry<S, TreeSet<T>> entry : input.entrySet()) {
            Comparable inputKey = (Comparable)entry.getKey();
            for (Comparable inputValue : entry.getValue()) {
                output.addToList(inputValue, inputKey);
            }
        }
        return output;
    }
}

