/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.weak;

import com.softicar.platform.common.container.map.weak.IWeakMap;
import com.softicar.platform.common.container.map.weak.SubMap;
import com.softicar.platform.common.container.map.weak.WeakIntEntry;
import com.softicar.platform.common.container.map.weak.WeakIntHashMapIterator;
import com.softicar.platform.common.core.annotations.Nullable;
import com.softicar.platform.common.core.logging.Log;
import com.softicar.platform.common.core.utils.CastUtils;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;

public class WeakIntHashMap<V>
implements Iterable<V>,
IWeakMap<Integer, V> {
    private final SubMap<V> subMap;
    private final ReferenceQueue<V> referenceQueue = new ReferenceQueue();

    public WeakIntHashMap() {
        this.subMap = new SubMap();
    }

    public WeakIntHashMap(int maxLoadPercentage) {
        this.subMap = new SubMap(maxLoadPercentage);
    }

    @Override
    public final void collect() {
        Reference<V> reference;
        long time = System.currentTimeMillis();
        long removeTime = 0L;
        long maxRemove = 0L;
        int i = 0;
        while ((reference = this.referenceQueue.poll()) != null) {
            WeakIntEntry<V> collectedEntry = this.castEntry(reference);
            long a = System.currentTimeMillis();
            WeakIntEntry removedEntry = (WeakIntEntry)this.subMap.remove(collectedEntry.getKey());
            long b = System.currentTimeMillis();
            removeTime += b - a;
            if (b - a > maxRemove) {
                maxRemove = b - a;
            }
            if (removedEntry == null) continue;
            Object removedValue = removedEntry.get();
            if (removedValue != null) {
                this.subMap.add(removedEntry);
                continue;
            }
            ++i;
        }
        if (i > 0) {
            Log.fverbose((String)"WeakIntHashMap: %s entries collected, new size: %s (%s ms, %s ms, %s ms)", (Object[])new Object[]{i, this.size(), System.currentTimeMillis() - time, removeTime, maxRemove});
        }
    }

    @Override
    public final Iterator<V> iterator() {
        return new WeakIntHashMapIterator(this.subMap.iterator());
    }

    @Override
    @Nullable
    public final V put(Integer key, V value) {
        this.collect();
        WeakIntEntry<V> entry = this.subMap.add(this.createEntry(key, value, this.referenceQueue));
        return entry != null ? (V)entry.get() : null;
    }

    @Override
    @Nullable
    public final V get(Integer key) {
        this.collect();
        WeakIntEntry entry = (WeakIntEntry)this.subMap.get(key);
        return entry != null ? (V)entry.get() : null;
    }

    @Override
    @Nullable
    public final V remove(Integer key) {
        this.collect();
        WeakIntEntry entry = (WeakIntEntry)this.subMap.remove(key);
        return entry != null ? (V)entry.get() : null;
    }

    public final double getStepAverage() {
        return this.subMap.getStepAverage();
    }

    public final double getClusterAverage() {
        return this.subMap.getClusterAverage();
    }

    @Override
    public final int size() {
        return this.subMap.size();
    }

    public final boolean isEmpty() {
        return this.subMap.isEmpty();
    }

    public final String toString() {
        return this.subMap.toString();
    }

    protected WeakIntEntry<V> createEntry(int key, V value, ReferenceQueue<V> referenceQueue) {
        return new WeakIntEntry<V>(key, value, referenceQueue);
    }

    private WeakIntEntry<V> castEntry(Object entry) {
        return (WeakIntEntry)CastUtils.cast((Object)entry);
    }
}

