/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.weak;

import com.softicar.platform.common.container.map.weak.IWeakMap;
import com.softicar.platform.common.core.annotations.Nullable;
import com.softicar.platform.common.core.logging.Log;
import com.softicar.platform.common.core.utils.CastUtils;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.TreeMap;

public class WeakIntTreeMap<V>
implements IWeakMap<Integer, V> {
    private final ReferenceQueue<V> _queue = new ReferenceQueue();
    private final TreeMap<Integer, WeakEntry<Integer, V>> _map = new TreeMap();

    @Override
    public V put(Integer key, V value) {
        this.collect();
        if (key != null) {
            this._map.put(key, new WeakEntry(this, (Comparable)key, value, this._queue));
        }
        return value;
    }

    @Override
    @Nullable
    public V get(Integer key) {
        this.collect();
        WeakEntry<Integer, V> weakValue = this._map.get(key);
        if (weakValue != null) {
            return (V)weakValue.get();
        }
        return null;
    }

    @Override
    @Nullable
    public V remove(Integer key) {
        this.collect();
        WeakEntry<Integer, V> weakEntry = this._map.remove(key);
        if (weakEntry != null) {
            return (V)weakEntry.get();
        }
        return null;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public void collect() {
        Reference<V> reference;
        long time = System.currentTimeMillis();
        long removeTime = 0L;
        long maxRemove = 0L;
        int i = 0;
        while ((reference = this._queue.poll()) != null) {
            WeakEntry collectedEntry = (WeakEntry)CastUtils.cast(reference);
            long a = System.currentTimeMillis();
            WeakEntry<Integer, V> removedEntry = this._map.remove(collectedEntry.getKey());
            long b = System.currentTimeMillis();
            removeTime += b - a;
            if (b - a > maxRemove) {
                maxRemove = b - a;
            }
            if (removedEntry == null) continue;
            Object removedValue = removedEntry.get();
            if (removedValue != null) {
                this._map.put(removedEntry.getKey(), removedEntry);
                continue;
            }
            ++i;
        }
        if (i > 0) {
            Log.fverbose((String)"WeakIntHashMap: %s entries collected, new size: %s (%s ms, %s ms, %s ms)", (Object[])new Object[]{i, this.size(), System.currentTimeMillis() - time, removeTime, maxRemove});
        }
    }

    private static class WeakEntry<KK extends Comparable<KK>, VV>
    extends WeakReference<VV>
    implements Comparable<WeakEntry<KK, VV>> {
        private final KK key;
        final /* synthetic */ WeakIntTreeMap this$0;

        public WeakEntry(KK key, VV value, ReferenceQueue<VV> queue) {
            this.this$0 = var1_1;
            super(value, queue);
            this.key = key;
        }

        public KK getKey() {
            return this.key;
        }

        @Override
        public int compareTo(WeakEntry<KK, VV> o) {
            if (o != null && o.key != null) {
                return this.key.compareTo(o.key);
            }
            return 1;
        }

        public String toString() {
            return "" + this.get();
        }
    }
}

