/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.weak.identity;

import com.softicar.platform.common.container.map.weak.identity.WeakIdentityReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class WeakIdentityHashMap<K, V> {
    private final Map<WeakIdentityReference<K>, V> hashMap;
    private final ReferenceQueue<K> referenceQueue;

    public WeakIdentityHashMap() {
        this(HashMap::new);
    }

    public WeakIdentityHashMap(Supplier<Map<WeakIdentityReference<K>, V>> factory) {
        this.hashMap = factory.get();
        this.referenceQueue = new ReferenceQueue();
    }

    public V get(K key) {
        this.collect();
        WeakIdentityReference<K> reference = new WeakIdentityReference<K>(key);
        return this.hashMap.get(reference);
    }

    public V put(K key, V value) {
        this.collect();
        if (key == null) {
            throw new IllegalArgumentException("No null keys allowed.");
        }
        WeakIdentityReference<K> reference = new WeakIdentityReference<K>(key, this.referenceQueue);
        return this.hashMap.put(reference, value);
    }

    public V remove(K key) {
        this.collect();
        WeakIdentityReference<K> reference = new WeakIdentityReference<K>(key);
        return this.hashMap.remove(reference);
    }

    public int size() {
        this.collect();
        return this.hashMap.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void collect() {
        Reference<K> deadReference;
        while ((deadReference = this.referenceQueue.poll()) != null) {
            this.hashMap.remove(deadReference);
        }
    }
}

