/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.map.weak.map.adapter;

import com.softicar.platform.common.core.utils.CastUtils;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class WeakValueMapAdapter<K, V> {
    private final Map<K, ValueReference> map;
    private final ReferenceQueue<V> referenceQueue;

    public WeakValueMapAdapter(Supplier<Map<K, ValueReference>> mapFactory) {
        this.map = mapFactory.get();
        this.referenceQueue = new ReferenceQueue();
    }

    public void put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.collect();
        this.map.put(key, new ValueReference(key, value));
    }

    public void remove(K key) {
        Objects.requireNonNull(key);
        this.collect();
        this.map.remove(key);
    }

    public Optional<V> get(K key) {
        Objects.requireNonNull(key);
        this.collect();
        return Optional.ofNullable(this.map.get(key)).map(Reference::get);
    }

    private void collect() {
        Reference<V> reference;
        while ((reference = this.referenceQueue.poll()) != null) {
            this.collect(reference);
        }
    }

    private void collect(Reference<? extends V> reference) {
        CastUtils.tryCast(reference, ValueReference.class).ifPresent(it -> this.map.remove(it.getKey()));
    }

    public class ValueReference
    extends WeakReference<V> {
        private final K key;

        public ValueReference(K key, V value) {
            super(value, WeakValueMapAdapter.this.referenceQueue);
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }
    }
}

