/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.matrix;

import com.softicar.platform.common.container.matrix.AsciiTableCell;
import com.softicar.platform.common.string.Padding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AsciiTable {
    private static final String EOL = "\r\n";
    private final List<List<AsciiTableCell>> rows = new ArrayList<List<AsciiTableCell>>();
    private final Integer colCount;
    private List<AsciiTableCell> currentRow;

    public AsciiTable(int colCount) {
        this.colCount = colCount;
    }

    public AsciiTable(String ... columns) {
        this.colCount = columns.length;
        for (String column : columns) {
            this.add(column, Alignment.ALIGN_CENTER);
        }
    }

    public int getColumntCount() {
        return this.colCount;
    }

    public Collection<List<AsciiTableCell>> getRows() {
        return Collections.unmodifiableCollection(this.rows);
    }

    public AsciiTable add(Object object) {
        if (this.isInHeadline()) {
            return this.add(object, Alignment.ALIGN_CENTER);
        }
        if (object instanceof Number) {
            return this.add(object, Alignment.ALIGN_RIGHT);
        }
        return this.add(object, Alignment.ALIGN_LEFT);
    }

    private boolean isInHeadline() {
        return this.currentRow == null || this.rows.size() == 1 && this.currentRow.size() < this.colCount;
    }

    public AsciiTable add(Object object, Alignment alignment) {
        if (this.isNeedNewRow()) {
            this.currentRow = new ArrayList<AsciiTableCell>();
            this.rows.add(this.currentRow);
        }
        this.currentRow.add(new AsciiTableCell("" + object, alignment));
        return this;
    }

    private boolean isNeedNewRow() {
        return this.currentRow == null || this.currentRow.size() == this.colCount.intValue();
    }

    public String toString() {
        int rowCount = this.rows.size();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        for (int c = 0; c != this.colCount; ++c) {
            widths.add(0);
        }
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c != this.colCount; ++c) {
                widths.set(c, Math.max((Integer)widths.get(c), this.rows.get(r).get(c).getWidth()));
            }
        }
        StringBuilder sb = new StringBuilder();
        AsciiTable.generateSeparator(sb, widths);
        AsciiTable.generateRow(sb, this.rows.get(0), widths);
        AsciiTable.generateSeparator(sb, widths);
        for (int i = 1; i < rowCount; ++i) {
            AsciiTable.generateRow(sb, this.rows.get(i), widths);
        }
        AsciiTable.generateSeparator(sb, widths);
        return sb.toString();
    }

    private static void generateSeparator(StringBuilder sb, Collection<Integer> widths) {
        sb.append("+");
        for (Integer width : widths) {
            sb.append(Padding.generate((char)'-', (int)(2 + width)));
            sb.append("+");
        }
        sb.append(EOL);
    }

    private static void generateRow(StringBuilder sb, List<AsciiTableCell> cells, List<Integer> widths) {
        sb.append("|");
        for (int i = 0; i != cells.size(); ++i) {
            sb.append(" ");
            cells.get(i).append(sb, widths.get(i));
            sb.append(" |");
        }
        sb.append(EOL);
    }

    public static enum Alignment {
        ALIGN_LEFT,
        ALIGN_RIGHT,
        ALIGN_CENTER;

    }
}

