/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.matrix;

import com.softicar.platform.common.container.matrix.AsciiTable;

public class AsciiTableCell {
    private final String text;
    private final AsciiTable.Alignment alignment;

    public AsciiTableCell(String text, AsciiTable.Alignment alignment) {
        this.text = text;
        this.alignment = alignment;
    }

    public int getWidth() {
        return this.text.length();
    }

    public void append(StringBuilder sb, int width) {
        switch (this.alignment) {
            case ALIGN_LEFT: {
                sb.append(this.text);
                AsciiTableCell.generate(sb, ' ', width - this.text.length());
                break;
            }
            case ALIGN_RIGHT: {
                AsciiTableCell.generate(sb, ' ', width - this.text.length());
                sb.append(this.text);
                break;
            }
            case ALIGN_CENTER: {
                int left = (width - this.text.length()) / 2;
                int right = width - left - this.text.length();
                AsciiTableCell.generate(sb, ' ', left);
                sb.append(this.text);
                AsciiTableCell.generate(sb, ' ', right);
            }
        }
    }

    private static void generate(StringBuilder sb, char c, int width) {
        for (int i = 0; i != width; ++i) {
            sb.append(c);
        }
    }
}

