/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.matrix;

import com.softicar.platform.common.container.matrix.IMatrix;
import com.softicar.platform.common.container.matrix.IMatrixTraits;
import com.softicar.platform.common.container.matrix.simple.SimpleMatrix;
import com.softicar.platform.common.container.matrix.traits.BigDecimalMatrixTraits;
import com.softicar.platform.common.container.matrix.traits.CharacterMatrixTraits;
import com.softicar.platform.common.container.matrix.traits.DoubleMatrixTraits;
import com.softicar.platform.common.container.matrix.traits.IntegerMatrixTraits;
import com.softicar.platform.common.container.matrix.traits.LongMatrixTraits;
import com.softicar.platform.common.container.matrix.traits.ObjectMatrixTraits;
import java.math.BigDecimal;
import java.util.Comparator;

public class MatrixFactory {
    public static <R, C, V> IMatrix<R, C, V> createMatrix(IMatrixTraits<V> traits) {
        return new SimpleMatrix(traits);
    }

    public static <R, C, V> IMatrix<R, C, V> createMatrix(IMatrixTraits<V> traits, Comparator<R> rowComparator, Comparator<C> columnComparator) {
        return new SimpleMatrix<R, C, V>(traits, rowComparator, columnComparator);
    }

    public static <R, C, V> IMatrix<R, C, V> createObjectMatrix() {
        return MatrixFactory.createMatrix(new ObjectMatrixTraits());
    }

    public static <R, C, V> IMatrix<R, C, V> createObjectMatrix(Comparator<R> rowComparator, Comparator<C> columnComparator) {
        return MatrixFactory.createMatrix(new ObjectMatrixTraits(), rowComparator, columnComparator);
    }

    public static <R, C> IMatrix<R, C, Integer> createIntegerMatrix() {
        return MatrixFactory.createMatrix(new IntegerMatrixTraits());
    }

    public static <R, C> IMatrix<R, C, Integer> createIntegerMatrix(Comparator<R> rowComparator, Comparator<C> columnComparator) {
        return MatrixFactory.createMatrix(new IntegerMatrixTraits(), rowComparator, columnComparator);
    }

    public static <R, C> IMatrix<R, C, Character> createCharacterMatrix() {
        return MatrixFactory.createMatrix(new CharacterMatrixTraits());
    }

    public static <R, C> IMatrix<R, C, Long> createLongMatrix() {
        return MatrixFactory.createMatrix(new LongMatrixTraits());
    }

    public static <R, C> IMatrix<R, C, Double> createDoubleMatrix() {
        return MatrixFactory.createMatrix(new DoubleMatrixTraits());
    }

    public static <R, C> IMatrix<R, C, BigDecimal> createBigDecimalMatrix() {
        return MatrixFactory.createMatrix(new BigDecimalMatrixTraits());
    }
}

