/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.matrix;

import com.softicar.platform.common.container.matrix.IImmutableMatrix;
import com.softicar.platform.common.container.matrix.IMatrixCell;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ValueMappingMatrix<R, C, U, V>
implements IImmutableMatrix<R, C, V> {
    private final IImmutableMatrix<R, C, U> matrix;
    private final Function<U, V> valueMapper;

    public ValueMappingMatrix(IImmutableMatrix<R, C, U> matrix, Function<U, V> valueMapper) {
        this.matrix = matrix;
        this.valueMapper = valueMapper;
    }

    @Override
    public Iterable<IMatrixCell<R, C, V>> getMatrixCells() {
        return StreamSupport.stream(this.matrix.getMatrixCells().spliterator(), false).map(x$0 -> new MatrixCell(x$0)).collect(Collectors.toList());
    }

    @Override
    public IImmutableMatrix<R, C, V> clone() {
        return new ValueMappingMatrix<R, C, U, V>(this.matrix.clone(), this.valueMapper);
    }

    @Override
    public V getValue(R row, C column) {
        return this.valueMapper.apply(this.matrix.getValue(row, column));
    }

    @Override
    public V getTotalValue(R row) {
        return this.valueMapper.apply(this.matrix.getTotalValue(row));
    }

    @Override
    public V getTotalColumnValue(C column) {
        return this.valueMapper.apply(this.matrix.getTotalColumnValue(column));
    }

    @Override
    public boolean isSet(R row, C column) {
        return this.matrix.isSet(row, column);
    }

    @Override
    public V getDefaultValue() {
        return this.valueMapper.apply(this.matrix.getDefaultValue());
    }

    @Override
    public SortedSet<R> getRows() {
        return this.matrix.getRows();
    }

    @Override
    public boolean containsRow(R row) {
        return this.matrix.containsRow(row);
    }

    @Override
    public R getFirstRow() {
        return this.matrix.getFirstRow();
    }

    @Override
    public R getLastRow() {
        return this.matrix.getLastRow();
    }

    @Override
    public int getRowCount() {
        return this.matrix.getRowCount();
    }

    @Override
    public Map<C, V> getRowMap(R row) {
        return this.matrix.getRowMap(row).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.valueMapper.apply(entry.getValue())));
    }

    @Override
    public SortedSet<C> getColumns() {
        return this.matrix.getColumns();
    }

    @Override
    public boolean containsColumn(C column) {
        return this.matrix.containsColumn(column);
    }

    @Override
    public C getFirstColumn() {
        return this.matrix.getFirstColumn();
    }

    @Override
    public C getLastColumn() {
        return this.matrix.getLastColumn();
    }

    @Override
    public int getColumnCount() {
        return this.matrix.getColumnCount();
    }

    @Override
    public Collection<C> getColumnsWithNonDefaultValue(R row) {
        return this.matrix.getColumnsWithNonDefaultValue(row);
    }

    private class MatrixCell
    implements IMatrixCell<R, C, V> {
        private final IMatrixCell<R, C, U> matrixCell;

        public MatrixCell(IMatrixCell<R, C, U> matrixCell) {
            this.matrixCell = matrixCell;
        }

        @Override
        public R getRow() {
            return this.matrixCell.getRow();
        }

        @Override
        public C getColumn() {
            return this.matrixCell.getColumn();
        }

        @Override
        public V getValue() {
            return ValueMappingMatrix.this.valueMapper.apply(this.matrixCell.getValue());
        }
    }
}

