/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.matrix.data.table;

import com.softicar.platform.common.container.data.table.in.memory.AbstractInMemoryDataTable;
import com.softicar.platform.common.container.matrix.IMatrix;
import com.softicar.platform.common.container.matrix.data.table.MatrixDataTableRow;
import com.softicar.platform.common.core.i18n.IDisplayString;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class MatrixDataTable<R, C, V>
extends AbstractInMemoryDataTable<MatrixDataTableRow<R, C, V>> {
    private final List<MatrixDataTableRow<R, C, V>> rows;

    public MatrixDataTable(IMatrix<R, C, V> matrix, Class<R> rowClass, Class<V> valueClass, IDisplayString rowTitle, Function<C, IDisplayString> columnNameFunction) {
        this.newColumn(rowClass).setGetter(row -> row.getRow()).setTitle(rowTitle).addColumn();
        for (Object col : matrix.getColumns()) {
            this.newColumn(valueClass).setGetter(row -> row.getValue(col)).setTitle(columnNameFunction.apply(col)).addColumn();
        }
        this.rows = new ArrayList<MatrixDataTableRow<R, C, V>>();
        for (Object row2 : matrix.getRows()) {
            this.rows.add(new MatrixDataTableRow(row2, matrix.getRowMap(row2)));
        }
    }

    @Override
    protected Iterable<MatrixDataTableRow<R, C, V>> getTableRows() {
        return this.rows;
    }
}

