/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.matrix.simple;

import com.softicar.platform.common.container.matrix.AsciiTable;
import com.softicar.platform.common.container.matrix.IMatrix;
import com.softicar.platform.common.container.matrix.IMatrixCell;
import com.softicar.platform.common.container.matrix.IMatrixTraits;
import com.softicar.platform.common.container.matrix.simple.SimpleMatrixCellIterable;
import com.softicar.platform.common.container.matrix.simple.SimpleMatrixRowMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class SimpleMatrix<R, C, V>
implements IMatrix<R, C, V> {
    private final IMatrixTraits<V> traits;
    private final SortedSet<R> rows;
    private final SortedSet<C> columns;
    private final SortedMap<R, Map<C, V>> values;

    public SimpleMatrix(IMatrixTraits<V> traits) {
        this.traits = traits;
        this.rows = new TreeSet<R>();
        this.columns = new TreeSet<C>();
        this.values = new TreeMap<R, Map<C, V>>();
    }

    public SimpleMatrix(IMatrixTraits<V> traits, Comparator<? super R> rowComparator, Comparator<? super C> colComparator) {
        this.traits = traits;
        this.rows = rowComparator == null ? new TreeSet<R>() : new TreeSet<R>(rowComparator);
        this.columns = colComparator == null ? new TreeSet<C>() : new TreeSet<C>(colComparator);
        this.values = new TreeMap<R, Map<C, V>>(rowComparator);
    }

    public SimpleMatrix(SimpleMatrix<R, C, V> other) {
        this(other.traits, other.rows.comparator(), other.columns.comparator());
        for (Map.Entry<R, Map<C, V>> row : other.values.entrySet()) {
            for (Map.Entry<C, V> col : row.getValue().entrySet()) {
                this.setValue(row.getKey(), col.getKey(), col.getValue());
            }
        }
    }

    @Override
    public IMatrix<R, C, V> clone() {
        return new SimpleMatrix<R, C, V>(this);
    }

    @Override
    public Iterable<IMatrixCell<R, C, V>> getMatrixCells() {
        return new SimpleMatrixCellIterable<R, C, V>(this.values);
    }

    @Override
    public V getValue(R row, C column) {
        Map rowValues = (Map)this.values.get(row);
        if (rowValues != null) {
            Object value = rowValues.get(column);
            if (value != null) {
                return value;
            }
            return this.traits.getDefaultValue();
        }
        return this.traits.getDefaultValue();
    }

    @Override
    public V getTotalValue(R row) {
        V result = this.getTraits().getDefaultValue();
        for (Object column : this.getColumns()) {
            result = this.getTraits().plus(result, this.getValue(row, column));
        }
        return result;
    }

    @Override
    public V getTotalColumnValue(C column) {
        V result = this.getTraits().getDefaultValue();
        for (Object row : this.getRows()) {
            result = this.getTraits().plus(result, this.getValue(row, column));
        }
        return result;
    }

    @Override
    public void setValue(R row, C column, V value) {
        TreeMap<C, V> rowValues = (TreeMap<C, V>)this.values.get(row);
        if (rowValues == null) {
            rowValues = new TreeMap<C, V>(this.columns.comparator());
            this.values.put(row, rowValues);
        }
        rowValues.put(column, value);
        this.rows.add(row);
        this.columns.add(column);
    }

    @Override
    public void addValue(R row, C column, V value) {
        this.setValue(row, column, this.traits.plus(this.getValue(row, column), value));
    }

    @Override
    public void removeValue(R row, C column) {
        Map rowValues = (Map)this.values.get(row);
        if (rowValues != null) {
            rowValues.remove(column);
            if (rowValues.isEmpty()) {
                this.values.remove(row);
            }
        }
    }

    @Override
    public V getDefaultValue() {
        return this.traits.getDefaultValue();
    }

    @Override
    public boolean isSet(R row, C column) {
        Map rowValues = (Map)this.values.get(row);
        return rowValues != null && rowValues.get(column) != null;
    }

    public IMatrixTraits<V> getTraits() {
        return this.traits;
    }

    @Override
    public SortedSet<R> getRows() {
        return this.rows;
    }

    public Collection<R> getRowsWithNonDefaultValue(C column) {
        TreeSet rows = new TreeSet();
        for (Object row : this.getRows()) {
            if (this.getValue(row, column).equals(this.getDefaultValue())) continue;
            rows.add(row);
        }
        return rows;
    }

    @Override
    public void addRow(R row) {
        this.rows.add(row);
    }

    @Override
    public void removeRow(R row) {
        this.values.remove(row);
        this.rows.remove(row);
    }

    @Override
    public void resetRow(R row) {
        this.values.remove(row);
    }

    @Override
    public boolean containsRow(R row) {
        return this.rows.contains(row);
    }

    @Override
    public R getFirstRow() {
        return this.rows.first();
    }

    @Override
    public R getLastRow() {
        return this.rows.last();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Map<C, V> getRowMap(R row) {
        return new SimpleMatrixRowMap(this, row);
    }

    @Override
    public SortedSet<C> getColumns() {
        return this.columns;
    }

    @Override
    public Collection<C> getColumnsWithNonDefaultValue(R row) {
        TreeSet columns = new TreeSet();
        for (Object column : this.getColumns()) {
            if (this.getValue(row, column).equals(this.getDefaultValue())) continue;
            columns.add(column);
        }
        return columns;
    }

    @Override
    public void addColumn(C column) {
        this.columns.add(column);
    }

    @Override
    public void removeColumn(C column) {
        for (Map<C, V> rowValues : this.values.values()) {
            rowValues.remove(column);
        }
        this.columns.remove(column);
    }

    public void addAndRemoveRow(R sourceRowKey, R targetRowKey) {
        Map sourceRow = (Map)this.values.remove(sourceRowKey);
        if (sourceRow != null) {
            for (Map.Entry entry : sourceRow.entrySet()) {
                this.addValue(targetRowKey, entry.getKey(), entry.getValue());
            }
        }
        this.rows.remove(sourceRowKey);
        this.rows.add(sourceRowKey);
    }

    public void addAndRemoveColumn(C sourceColumn, C targetColumn) {
        for (Map<C, V> rowValues : this.values.values()) {
            V source = rowValues.remove(sourceColumn);
            V target = rowValues.get(targetColumn);
            if (source == null) continue;
            if (target != null) {
                rowValues.put(targetColumn, this.traits.plus(source, target));
                continue;
            }
            rowValues.put(targetColumn, source);
        }
        this.columns.remove(sourceColumn);
        this.columns.add(targetColumn);
    }

    public void addAndRemoveColumns(Iterable<C> sourceColumns, C targetColumn) {
        for (Map<C, V> rowValues : this.values.values()) {
            V target = rowValues.get(targetColumn);
            for (C sourceColumn : sourceColumns) {
                V source = rowValues.remove(sourceColumn);
                if (source == null) continue;
                if (target != null) {
                    target = this.traits.plus(source, target);
                    continue;
                }
                target = source;
            }
            if (target == null) continue;
            rowValues.put(targetColumn, target);
        }
        for (Map<Object, V> sourceColumn : sourceColumns) {
            this.columns.remove(sourceColumn);
        }
        this.columns.add(targetColumn);
    }

    @Override
    public void resetColumn(C column) {
        for (Map<C, V> m_rowValues : this.values.values()) {
            m_rowValues.remove(column);
        }
    }

    @Override
    public boolean containsColumn(C column) {
        return this.columns.contains(column);
    }

    @Override
    public C getFirstColumn() {
        return this.columns.first();
    }

    @Override
    public C getLastColumn() {
        return this.columns.last();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public void merge(SimpleMatrix<R, C, V> other) {
        for (Object e : other.getRows()) {
            this.addRow(e);
        }
        for (Object e : other.getColumns()) {
            this.addColumn(e);
        }
        for (Map.Entry entry : other.values.entrySet()) {
            for (Map.Entry cm : ((Map)entry.getValue()).entrySet()) {
                this.setValue(entry.getKey(), cm.getKey(), cm.getValue());
            }
        }
    }

    public <RR extends R, CC extends C> void add(SimpleMatrix<RR, CC, V> other) {
        for (Object e : other.getRows()) {
            this.addRow(e);
        }
        for (Object e : other.getColumns()) {
            this.addColumn(e);
        }
        for (Map.Entry entry : other.values.entrySet()) {
            for (Map.Entry cm : ((Map)entry.getValue()).entrySet()) {
                this.addValue(entry.getKey(), cm.getKey(), cm.getValue());
            }
        }
    }

    @Override
    public String toString() {
        Object result = "";
        for (Object row : this.rows) {
            result = (String)result + this.rowToString(row) + "\n";
        }
        return result;
    }

    public AsciiTable toAsciiTable() {
        AsciiTable a = new AsciiTable(this.columns.size() + 1);
        a.add("");
        for (Object column : this.columns) {
            a.add(column);
        }
        for (Object row : this.rows) {
            a.add(row);
            for (Object column : this.columns) {
                a.add(this.getValue(row, column));
            }
        }
        return a;
    }

    private String rowToString(R row) {
        String result = row + ": {";
        for (Object column : this.columns) {
            result = result + " " + column + ": " + this.getValue(row, column) + ";";
        }
        result = result + " }";
        return result;
    }
}

