/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.matrix.simple;

import com.softicar.platform.common.container.matrix.simple.SimpleMatrix;
import com.softicar.platform.common.core.utils.CastUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class SimpleMatrixRowMap<R, C, V>
implements Map<C, V> {
    private final SimpleMatrix<R, C, V> matrix;
    private final R row;

    public SimpleMatrixRowMap(SimpleMatrix<R, C, V> matrix, R row) {
        this.matrix = matrix;
        this.row = row;
    }

    @Override
    public int size() {
        return this.matrix.getColumnCount();
    }

    @Override
    public boolean isEmpty() {
        return this.matrix.getColumnCount() != 0;
    }

    @Override
    public boolean containsKey(Object column) {
        return this.matrix.containsColumn(CastUtils.cast((Object)column));
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object column) {
        return this.matrix.getValue(this.row, CastUtils.cast((Object)column));
    }

    @Override
    public V put(C column, V value) {
        V previous = this.matrix.getValue(this.row, column);
        this.matrix.setValue(this.row, column, value);
        return previous;
    }

    @Override
    public V remove(Object key) {
        V value = this.get(key);
        this.matrix.removeValue(this.row, CastUtils.cast((Object)key));
        return value;
    }

    @Override
    public void putAll(Map<? extends C, ? extends V> m) {
        for (Map.Entry<C, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<C> keySet() {
        return this.matrix.getColumns();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (C column : this.keySet()) {
            values.add(this.matrix.getValue(this.row, column));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<C, V>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

