/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.pair;

import com.softicar.platform.common.container.map.list.ListTreeMap;
import com.softicar.platform.common.container.pair.Pair;
import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PairList<A extends Comparable<?>, B>
extends ArrayList<Pair<A, B>> {
    private static final long serialVersionUID = 1L;

    public void add(A first, B second) {
        this.add(new Pair<A, B>(first, second));
    }

    public void addAll(Map<A, B> map) {
        for (Map.Entry<A, B> entry : map.entrySet()) {
            this.add(new Pair<Comparable, B>((Comparable)entry.getKey(), entry.getValue()));
        }
    }

    public void addAll(PairList<A, B> other) {
        for (Pair pair : other) {
            this.add(pair);
        }
    }

    public List<A> getAllFirst() {
        ArrayList<Comparable> allFirst = new ArrayList<Comparable>();
        for (Pair pair : this) {
            allFirst.add((Comparable)pair.getFirst());
        }
        return allFirst;
    }

    public List<B> getAllSecond() {
        ArrayList allSecond = new ArrayList();
        for (Pair pair : this) {
            allSecond.add(pair.getSecond());
        }
        return allSecond;
    }

    public boolean containsFirst(A first) {
        for (Pair pair : this) {
            Comparable existingFirst = (Comparable)pair.getFirst();
            if (!(first == null ? existingFirst == null : first.equals(existingFirst))) continue;
            return true;
        }
        return false;
    }

    public TreeMap<A, B> createNewTreeMap(boolean throwOnDuplicateKey) {
        TreeMap map = new TreeMap();
        for (Pair pair : this) {
            Comparable first = (Comparable)pair.getFirst();
            Object second = pair.getSecond();
            if (throwOnDuplicateKey && map.containsKey(first)) {
                throw new SofticarDeveloperException("Duplicate keys are not allowed.");
            }
            map.put(first, second);
        }
        return map;
    }

    public ListTreeMap<A, B> createNewListTreeMap() {
        ListTreeMap map = new ListTreeMap();
        for (Pair pair : this) {
            map.addToList((Comparable)pair.getFirst(), pair.getSecond());
        }
        return map;
    }
}

