/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.schedule;

import com.softicar.platform.common.container.matrix.traits.DoubleMatrixTraits;
import com.softicar.platform.common.container.schedule.IDoubleSchedule;
import com.softicar.platform.common.container.schedule.SimpleSchedule;
import java.util.Comparator;
import java.util.Map;

public class DoubleSchedule<R extends Comparable<? super R>, C extends Comparable<? super C>>
extends SimpleSchedule<R, C, Double>
implements IDoubleSchedule<R, C> {
    public DoubleSchedule(C backorderColumn) {
        super(new DoubleMatrixTraits(), backorderColumn, null, null);
    }

    public DoubleSchedule(C backorderColumn, Comparator<R> rowComparator, Comparator<C> colComparator) {
        super(new DoubleMatrixTraits(), backorderColumn, rowComparator, colComparator);
    }

    public void substractValue(R row, double value) {
        Map map = this.getRowMap(row);
        for (Comparable key : map.keySet()) {
            Double keyValue = (Double)map.get(key);
            if (value == 0.0) break;
            if (keyValue == null || keyValue == 0.0) continue;
            if (keyValue < 0.0) {
                value += Math.abs(keyValue);
                map.put(key, 0.0);
                continue;
            }
            if (value <= keyValue) {
                map.put(key, (Double)map.get(key) - value);
                value = 0.0;
                continue;
            }
            value -= ((Double)map.get(key)).doubleValue();
            map.put(key, 0.0);
        }
    }

    public void substractValue(Map<R, Double> keyValueMap) {
        for (Map.Entry<R, Double> entry : keyValueMap.entrySet()) {
            this.substractValue((Comparable)entry.getKey(), entry.getValue());
        }
    }
}

