/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.schedule;

import com.softicar.platform.common.container.matrix.IMatrixTraits;
import com.softicar.platform.common.container.matrix.simple.SimpleMatrix;
import com.softicar.platform.common.container.schedule.ISchedule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class SimpleSchedule<R extends Comparable<? super R>, C extends Comparable<? super C>, V>
extends SimpleMatrix<R, C, V>
implements ISchedule<R, C, V> {
    private final C backorderColumn;

    public SimpleSchedule(IMatrixTraits<V> traits, C backorderColumn) {
        super(traits);
        this.backorderColumn = backorderColumn;
        this.addColumn(backorderColumn);
    }

    public SimpleSchedule(IMatrixTraits<V> traits, C backorderColumn, Comparator<R> rowComparator, Comparator<C> colComparator) {
        super(traits, rowComparator, colComparator);
        this.backorderColumn = backorderColumn;
        this.addColumn(backorderColumn);
    }

    @Override
    public V getBackorder(R row) {
        return this.getValue(row, this.backorderColumn);
    }

    @Override
    public void setBackorder(R row, V value) {
        this.setValue(row, this.backorderColumn, value);
    }

    @Override
    public void addBackorder(R row, V value) {
        this.setBackorder(row, (V)this.getTraits().plus(this.getBackorder(row), value));
    }

    @Override
    public Collection<C> getColumnsWithoutBackorder() {
        TreeSet<Comparable> result = new TreeSet<Comparable>();
        for (Comparable col : this.getColumns()) {
            if (col == null || col.equals(this.backorderColumn)) continue;
            result.add(col);
        }
        return result;
    }

    @Override
    public C getBackorderColumn() {
        return this.backorderColumn;
    }

    @Override
    public void makeBackorder(C column) {
        assert (!column.equals(this.backorderColumn));
        this.addAndRemoveColumn(column, this.backorderColumn);
    }

    @Override
    public void makeBackorder(Collection<C> columns) {
        this.addAndRemoveColumns(columns, this.backorderColumn);
    }

    @Override
    public void makeBackorderBefore(C markerCol) {
        ArrayList<Comparable> toBeRemoved = new ArrayList<Comparable>();
        for (Comparable col : this.getColumnsWithoutBackorder()) {
            if (col.compareTo(markerCol) >= 0) continue;
            toBeRemoved.add(col);
        }
        this.makeBackorder((Collection<C>)toBeRemoved);
    }
}

