/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.schedule.coverage;

import com.softicar.platform.common.container.matrix.IImmutableMatrix;
import com.softicar.platform.common.container.schedule.coverage.ScheduleCoverage;
import com.softicar.platform.common.math.arithmetic.IArithmetic;
import java.util.Iterator;

class ScheduleCellIterator<Row, Column, Quantity extends Comparable<Quantity>> {
    private final IImmutableMatrix<Row, Column, Quantity> schedule;
    private final IArithmetic<Quantity> arithmetic;
    private final Row row;
    private final Iterator<Column> columnIterator;
    private Quantity quantity;
    private Column column;

    public ScheduleCellIterator(IImmutableMatrix<Row, Column, Quantity> schedule, IArithmetic<Quantity> arithmetic, Row row) {
        this.schedule = schedule;
        this.arithmetic = arithmetic;
        this.row = row;
        this.columnIterator = schedule.getColumns().iterator();
        this.column = null;
        this.quantity = (Comparable)arithmetic.getZero();
    }

    public Row getRow() {
        return this.row;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean gatherQuantity() {
        while (this.arithmetic.isZero(this.quantity)) {
            if (this.columnIterator.hasNext()) {
                this.column = this.columnIterator.next();
                this.quantity = (Comparable)this.schedule.getValue(this.row, this.column);
                continue;
            }
            return false;
        }
        return true;
    }

    public void transferToCoverage(ScheduleCoverage<Row, Column, Quantity> coverage, Quantity quantity) {
        coverage.addUnassignedQuantity(this.row, this.column, quantity);
        this.subtract(quantity);
    }

    public void transferToCoverage(ScheduleCoverage<Row, Column, Quantity> coverage, Column targetColumn, Quantity quantity) {
        coverage.addQuantity(this.row, this.column, targetColumn, quantity);
        this.subtract(quantity);
    }

    public void subtract(Quantity quantity) {
        this.quantity = (Comparable)this.arithmetic.minus(this.quantity, quantity);
    }
}

