/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.schedule.coverage;

import com.softicar.platform.common.container.matrix.IImmutableMatrix;
import com.softicar.platform.common.container.schedule.coverage.ScheduleCellIterator;
import com.softicar.platform.common.container.schedule.coverage.ScheduleCoverage;
import com.softicar.platform.common.math.arithmetic.IArithmetic;
import java.util.Set;
import java.util.TreeSet;

public class ScheduleCoverageComputer<Row, Column, Quantity extends Comparable<Quantity>> {
    protected final IImmutableMatrix<Row, Column, Quantity> todoSchedule;
    protected final IImmutableMatrix<Row, Column, Quantity> workSchedule;
    protected final IArithmetic<Quantity> arithmetic;
    protected final ScheduleCoverage<Row, Column, Quantity> todoCoverage;
    protected final ScheduleCoverage<Row, Column, Quantity> workCoverage;

    public ScheduleCoverageComputer(IImmutableMatrix<Row, Column, Quantity> todoSchedule, IImmutableMatrix<Row, Column, Quantity> workSchedule, IArithmetic<Quantity> arithmetic) {
        this.todoSchedule = todoSchedule;
        this.workSchedule = workSchedule;
        this.arithmetic = arithmetic;
        this.todoCoverage = new ScheduleCoverage(arithmetic);
        this.workCoverage = new ScheduleCoverage(arithmetic);
    }

    public Set<Row> getAllRows() {
        TreeSet<Row> rows = new TreeSet<Row>();
        rows.addAll(this.todoSchedule.getRows());
        rows.addAll(this.workSchedule.getRows());
        return rows;
    }

    public ScheduleCoverageComputer<Row, Column, Quantity> compute() {
        for (Row row : this.getAllRows()) {
            new RowCoverageComputer(row).compute();
        }
        return this;
    }

    public void computeRow(Row row) {
        this.todoCoverage.resetRow(row);
        this.workCoverage.resetRow(row);
        new RowCoverageComputer(row).compute();
    }

    public ScheduleCoverage<Row, Column, Quantity> getTodoCoverage() {
        return this.todoCoverage;
    }

    public ScheduleCoverage<Row, Column, Quantity> getWorkCoverage() {
        return this.workCoverage;
    }

    private class RowCoverageComputer {
        private final ScheduleCellIterator<Row, Column, Quantity> todoIterator;
        private final ScheduleCellIterator<Row, Column, Quantity> workIterator;
        private Quantity backlog;

        public RowCoverageComputer(Row row) {
            this.todoIterator = new ScheduleCellIterator(ScheduleCoverageComputer.this.todoSchedule, ScheduleCoverageComputer.this.arithmetic, row);
            this.workIterator = new ScheduleCellIterator(ScheduleCoverageComputer.this.workSchedule, ScheduleCoverageComputer.this.arithmetic, row);
            this.backlog = (Comparable)ScheduleCoverageComputer.this.arithmetic.getZero();
        }

        public void compute() {
            while (this.todoIterator.gatherQuantity() && this.workIterator.gatherQuantity()) {
                Object todoQuantity = this.todoIterator.getQuantity();
                Object workQuantity = this.workIterator.getQuantity();
                if (this.isNegative(todoQuantity)) {
                    this.handleNegativeTodoQuantity();
                    continue;
                }
                if (this.isNegative(workQuantity)) {
                    this.handleNegativeWorkQuantity(workQuantity);
                    continue;
                }
                if (this.isPositive(this.backlog)) {
                    this.handleBacklog();
                    continue;
                }
                Object minimum = this.getMinimum(todoQuantity, workQuantity);
                this.todoIterator.transferToCoverage(ScheduleCoverageComputer.this.todoCoverage, this.workIterator.getColumn(), minimum);
                this.workIterator.transferToCoverage(ScheduleCoverageComputer.this.workCoverage, this.todoIterator.getColumn(), minimum);
            }
            this.gatherRemainingQuantities(this.todoIterator, ScheduleCoverageComputer.this.todoCoverage);
            this.gatherRemainingQuantities(this.workIterator, ScheduleCoverageComputer.this.workCoverage);
        }

        private void handleNegativeTodoQuantity() {
            throw new IllegalArgumentException(String.format("Got negative to-do quantity '%s' for row '%s' and column '%s'. Quantities of the to-do schedule may not be negative.", this.todoIterator.getQuantity(), this.todoIterator.getRow(), this.todoIterator.getColumn()));
        }

        private void handleNegativeWorkQuantity(Quantity workQuantity) {
            this.backlog = (Comparable)ScheduleCoverageComputer.this.arithmetic.plus(this.backlog, (Object)((Comparable)ScheduleCoverageComputer.this.arithmetic.negate(workQuantity)));
            this.workIterator.transferToCoverage(ScheduleCoverageComputer.this.workCoverage, workQuantity);
        }

        private void handleBacklog() {
            Object minimum = this.getMinimum(this.backlog, this.workIterator.getQuantity());
            this.backlog = (Comparable)ScheduleCoverageComputer.this.arithmetic.minus(this.backlog, minimum);
            this.workIterator.transferToCoverage(ScheduleCoverageComputer.this.workCoverage, minimum);
        }

        private void gatherRemainingQuantities(ScheduleCellIterator<Row, Column, Quantity> iterator, ScheduleCoverage<Row, Column, Quantity> coverage) {
            while (iterator.gatherQuantity()) {
                iterator.transferToCoverage(coverage, iterator.getQuantity());
            }
        }

        private boolean isPositive(Quantity quantity) {
            return ScheduleCoverageComputer.this.arithmetic.isLess((Object)((Comparable)ScheduleCoverageComputer.this.arithmetic.getZero()), quantity);
        }

        private boolean isNegative(Quantity quantity) {
            return ScheduleCoverageComputer.this.arithmetic.isLess(quantity, (Object)((Comparable)ScheduleCoverageComputer.this.arithmetic.getZero()));
        }

        private Quantity getMinimum(Quantity a, Quantity b) {
            return ScheduleCoverageComputer.this.arithmetic.isLess(a, b) ? a : b;
        }
    }
}

