/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.schedule.coverage;

import com.softicar.platform.common.container.map.number.INumberMap;
import com.softicar.platform.common.container.map.number.NumberMap;
import com.softicar.platform.common.math.arithmetic.IArithmetic;

public class ScheduleCoverageEntry<Column, Quantity extends Comparable<Quantity>> {
    private final INumberMap<Column, Quantity> columnQuantities;
    private final Quantity unassignedQuantity;

    public ScheduleCoverageEntry(IArithmetic<Quantity> arithmetic) {
        this.columnQuantities = new NumberMap<Column, Quantity>(arithmetic);
        this.unassignedQuantity = (Comparable)arithmetic.getZero();
    }

    public ScheduleCoverageEntry(IArithmetic<Quantity> arithmetic, Quantity unassignedQuantity) {
        this.columnQuantities = new NumberMap<Column, Quantity>(arithmetic);
        this.unassignedQuantity = unassignedQuantity;
    }

    public ScheduleCoverageEntry(IArithmetic<Quantity> arithmetic, Column coveringColumn, Quantity quantity) {
        this(arithmetic);
        this.columnQuantities.add(coveringColumn, quantity);
    }

    public ScheduleCoverageEntry(IArithmetic<Quantity> arithmetic, ScheduleCoverageEntry<Column, Quantity> entry1, ScheduleCoverageEntry<Column, Quantity> entry2) {
        this(arithmetic, (Comparable)arithmetic.plus(entry1.getUnassignedQuantity(), entry2.getUnassignedQuantity()));
        this.columnQuantities.add(entry1.getColumnQuantities());
        this.columnQuantities.add(entry2.getColumnQuantities());
    }

    public INumberMap<Column, Quantity> getColumnQuantities() {
        return this.columnQuantities;
    }

    public Quantity getUnassignedQuantity() {
        return this.unassignedQuantity;
    }

    public Quantity getTotalQuantity() {
        Object totalQuantity = this.unassignedQuantity;
        IArithmetic<Quantity> arithmetic = this.columnQuantities.getArithmetic();
        for (Column column : this.columnQuantities.keySet()) {
            totalQuantity = (Comparable)arithmetic.plus(totalQuantity, (Object)((Comparable)this.columnQuantities.getOrZero(column)));
        }
        return totalQuantity;
    }
}

