/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.set;

import com.softicar.platform.common.core.utils.CastUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class SetFactory {
    public static <V> HashSet<V> createHashSet() {
        return new HashSet();
    }

    public static <V> HashSet<V> createHashSet(Collection<? extends V> collection) {
        return new HashSet<V>(collection);
    }

    @SafeVarargs
    public static <V> HashSet<V> createHashSetFrom(V ... values) {
        return new HashSet<V>(Arrays.asList(values));
    }

    public static <V> TreeSet<V> createTreeSet() {
        return new TreeSet();
    }

    public static <V> TreeSet<V> createTreeSet(Comparator<? super V> comparator) {
        return new TreeSet<V>(comparator);
    }

    public static <V> TreeSet<V> createTreeSet(Iterable<? extends V> iterable) {
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)CastUtils.cast(iterable);
            return SetFactory.createTreeSet(sortedSet);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)CastUtils.cast(iterable);
            return new TreeSet(collection);
        }
        TreeSet<V> treeSet = SetFactory.createTreeSet();
        for (V value : iterable) {
            treeSet.add(value);
        }
        return treeSet;
    }

    public static <V> TreeSet<V> createTreeSet(SortedSet<V> sortedSet) {
        return new TreeSet<V>(sortedSet);
    }

    @SafeVarargs
    public static <V> TreeSet<V> createTreeSetFrom(V ... values) {
        return SetFactory.createTreeSet(Arrays.asList(values));
    }
}

