/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.container.tuple;

import com.softicar.platform.common.container.tuple.TupleIterator;
import com.softicar.platform.common.string.Imploder;
import java.util.Iterator;

public abstract class AbstractTuple
implements Iterable<Object> {
    public final Object get(int index) {
        if (index >= 0 && index < this.size()) {
            return this.getElement(index);
        }
        throw new IndexOutOfBoundsException(String.format("Tried to access index %d of a tuple of size %d.", index, this.size()));
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final Iterator<Object> iterator() {
        return new TupleIterator(this);
    }

    public int hashCode() {
        int code = 0;
        for (Object object : this) {
            code += object != null ? object.hashCode() : 0;
        }
        return code;
    }

    public boolean equals(Object other) {
        AbstractTuple otherTuple;
        if (other instanceof AbstractTuple && (otherTuple = (AbstractTuple)other).size() == this.size()) {
            Iterator<Object> a = this.iterator();
            Iterator<Object> b = otherTuple.iterator();
            while (a.hasNext()) {
                Object y;
                Object x = a.next();
                if (x == (y = b.next()) || x != null && y != null && x.equals(y)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + Imploder.implode((Iterable)this, (String)", ") + "]";
    }

    protected abstract Object getElement(int var1);
}

