/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.Month;
import com.softicar.platform.common.date.Week;
import com.softicar.platform.common.date.Year;

public enum DateFormat {
    YY(Year.class, 0, 2, null, 0),
    YYYY(Year.class, 0, 4, null, 0),
    YYMM(Month.class, 2, 4, YY, 0),
    YYYYMM(Month.class, 4, 6, YYYY, 0),
    YYYY_MM(Month.class, 5, 7, YYYY, 0),
    YYYY____MM(Month.class, 8, 10, YYYY, 0),
    MMYYYY(Month.class, 0, 2, YYYY, 2),
    MMYY(Month.class, 0, 2, YY, 2),
    MM_YY(Month.class, 0, 2, YY, 3),
    MM_YYYY(Month.class, 0, 2, YYYY, 3),
    MM____YYYY(Month.class, 0, 2, YYYY, 6),
    MM____YY(Month.class, 0, 2, YY, 6),
    YY_MM___(Month.class, 3, 5, YY, 0),
    YYWW(Week.class, 2, 4, YY, 0),
    YY__WW(Week.class, 4, 6, YY, 0),
    YYYYWW(Week.class, 4, 6, YYYY, 0),
    YYMMDD(Day.class, 4, 6, YYMM, 0),
    YYYYMMDD(Day.class, 6, 8, YYYYMM, 0),
    YYYY_MM_DD(Day.class, 8, 10, YYYY_MM, 0),
    YYYY_DD_MM(Day.class, 5, 7, YYYY____MM, 0),
    DD_MM_YY(Day.class, 0, 2, MM_YY, 3),
    DD_MM_YYYY(Day.class, 0, 2, MM_YYYY, 3),
    DDMMYYYY(Day.class, 0, 2, MMYYYY, 2),
    DDMMYY(Day.class, 0, 2, MMYY, 2),
    MM_DD_YYYY(Day.class, 3, 5, MM____YYYY, 0),
    MM_DD_YY(Day.class, 3, 5, MM____YY, 0),
    YY_MM_DD(Day.class, 6, 8, YY_MM___, 0),
    YYWWD(Day.class, 4, 5, YYWW, 0),
    YYYYWWD(Day.class, 6, 7, YYYYWW, 0);

    private Class<?> m_type;
    private int m_begin;
    private int m_end;
    private int m_parentBegin;
    private DateFormat m_parent;

    public Year parseYear(String text) {
        if (this.m_type != Year.class) {
            throw new IllegalStateException("Called parseYear on a date format not representing a year.");
        }
        switch (this) {
            case YY: {
                Year currentYear = Day.today().getYear();
                int century = currentYear.getAbsoluteIndex() / 100 * 100;
                Year year = Year.get(century + this.parse(text));
                int distance = currentYear.getDistance(year);
                if (distance >= 50) {
                    year = year.getRelative(-100);
                }
                if (distance < -50) {
                    year = year.getRelative(100);
                }
                return year;
            }
            case YYYY: {
                return Year.get(this.parse(text));
            }
        }
        throw new IllegalStateException("Called parseYear on a date format not representing a year.");
    }

    public Month parseMonth(String text) {
        if (this.m_type != Month.class) {
            throw new IllegalStateException("Called parseMonth on a date format not representing a month.");
        }
        return this.m_parent.parseYear(text.substring(this.m_parentBegin)).getMonths().get(this.parse(text));
    }

    public Week parseWeek(String text) {
        if (this.m_type != Week.class) {
            throw new IllegalStateException("Called parseWeek on a date format not representing a week.");
        }
        return this.m_parent.parseYear(text.substring(this.m_parentBegin)).getWeeks().get(this.parse(text));
    }

    public Day parseDay(String text) {
        if (this.m_type != Day.class) {
            throw new IllegalStateException("Called parseDay on a date format not representing a day.");
        }
        if (this.m_parent.m_type == Month.class) {
            return this.m_parent.parseMonth(text.substring(this.m_parentBegin)).getDays().get(this.parse(text));
        }
        if (this.m_parent.m_type == Week.class) {
            return this.m_parent.parseWeek(text.substring(this.m_parentBegin)).getDays().get(this.parse(text));
        }
        throw new IllegalStateException("Invalid parent date format for day.");
    }

    private DateFormat(Class<?> type, int begin, int end, DateFormat parent, int parentBegin) {
        this.m_type = type;
        this.m_begin = begin;
        this.m_end = end;
        this.m_parent = parent;
        this.m_parentBegin = parentBegin;
    }

    private int parse(String text) {
        return Integer.parseInt(text.substring(this.m_begin, this.m_end));
    }
}

