/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.DateItemRange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;

public abstract class DateItem<T extends DateItem<T>>
implements Comparable<DateItem<T>> {
    public abstract int getAbsoluteIndex();

    public T getNext() {
        return this.getRelative(1);
    }

    public T getPrevious() {
        return this.getRelative(-1);
    }

    public abstract T getRelative(int var1);

    public int getDistance(DateItem<T> other) {
        return other.getAbsoluteIndex() - this.getAbsoluteIndex();
    }

    public DateItemRange<T> getRange(int size) {
        return new DateItemRange<T>(this.getRelative(-size), this.getRelative(size));
    }

    public DateItemRange<T> getRange(int fromIndex, int toIndex) {
        return new DateItemRange<T>(this.getRelative(fromIndex), this.getRelative(toIndex));
    }

    public int minus(DateItem<T> other) {
        return this.getAbsoluteIndex() - other.getAbsoluteIndex();
    }

    public int getAbsoluteDistance(DateItem<T> other) {
        return Math.abs(this.minus(other));
    }

    @Override
    public int compareTo(DateItem<T> other) {
        return this.minus(other);
    }

    public boolean equals(DateItem<?> other) {
        if (other == null) {
            return false;
        }
        return this.getAbsoluteIndex() == other.getAbsoluteIndex();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other.getClass() == this.getClass() && this.equals((DateItem)other);
    }

    public int hashCode() {
        return this.getAbsoluteIndex();
    }

    public boolean isAfter(DateItem<T> other) {
        return this.compareTo(other) > 0;
    }

    public boolean isAfterOrEqual(DateItem<T> other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isBefore(DateItem<T> other) {
        return this.compareTo(other) < 0;
    }

    public boolean isBeforeOrEqual(DateItem<T> other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isBetween(DateItem<T> first, DateItem<T> last) {
        return this.isAfterOrEqual(first) && this.isBeforeOrEqual(last);
    }

    @SafeVarargs
    public static <T extends DateItem<T>> T max(T ... dateItems) {
        return DateItem.max(Arrays.asList(dateItems));
    }

    public static <T extends DateItem<T>> T max(Collection<T> dateItems) {
        return (T)((DateItem)dateItems.stream().filter(Objects::nonNull).sorted(Comparator.reverseOrder()).findFirst().orElse(null));
    }

    @SafeVarargs
    public static <T extends DateItem<T>> T min(T ... dateItems) {
        return DateItem.min(Arrays.asList(dateItems));
    }

    public static <T extends DateItem<T>> T min(Collection<T> dateItems) {
        return (T)((DateItem)dateItems.stream().filter(Objects::nonNull).sorted().findFirst().orElse(null));
    }
}

