/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.DateItem;
import com.softicar.platform.common.date.DateItemIterator;
import java.util.Iterator;

public class DateItemRange<T extends DateItem<T>>
implements Iterable<T>,
Comparable<DateItemRange<T>> {
    private final T m_first;
    private final T m_last;

    public static <TT extends DateItem<TT>> DateItemRange<TT> make(TT first, TT last) {
        return new DateItemRange<TT>(first, last);
    }

    public DateItemRange(T first, T last) {
        this.m_first = first;
        this.m_last = last;
    }

    public DateItemRange(T first, int size) {
        this.m_first = first;
        this.m_last = ((DateItem)first).getRelative(size - 1);
    }

    public T getFirst() {
        return this.m_first;
    }

    public T getLast() {
        return this.m_last;
    }

    public T get(int index) {
        return ((DateItem)this.m_first).getRelative(index - 1);
    }

    public int size() {
        return ((DateItem)this.m_last).getAbsoluteIndex() - ((DateItem)this.m_first).getAbsoluteIndex() + 1;
    }

    public boolean contains(T item) {
        return ((DateItem)item).getAbsoluteIndex() >= ((DateItem)this.m_first).getAbsoluteIndex() && ((DateItem)item).getAbsoluteIndex() <= ((DateItem)this.m_last).getAbsoluteIndex();
    }

    @Override
    public Iterator<T> iterator() {
        return new DateItemIterator<T>(this.m_first, this.m_last);
    }

    @Override
    public int compareTo(DateItemRange<T> other) {
        int cmp1 = ((DateItem)this.m_first).compareTo(other.m_first);
        if (cmp1 < 0) {
            return -1;
        }
        if (cmp1 > 0) {
            return 1;
        }
        int cmp2 = ((DateItem)this.m_last).compareTo(other.m_last);
        if (cmp2 < 0) {
            return -1;
        }
        if (cmp2 > 0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(DateItemRange<T> other) {
        return ((DateItem)this.m_first).equals((DateItem<?>)other.m_first) && ((DateItem)this.m_last).equals((DateItem<?>)other.m_last);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((DateItem)this.m_first).hashCode();
        result = 31 * result + ((DateItem)this.m_last).hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof DateItemRange) {
            DateItemRange other = (DateItemRange)object;
            return ((DateItem)this.m_first).equals((DateItem<?>)other.m_first) && ((DateItem)this.m_last).equals((DateItem<?>)other.m_last);
        }
        return false;
    }

    public String toString() {
        return "(" + this.m_first + " --> " + this.m_last + ")";
    }
}

