/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.DayParser;
import com.softicar.platform.common.date.DayTime;
import com.softicar.platform.common.string.Imploder;
import com.softicar.platform.common.string.Padding;
import java.util.Date;

public class DateUtils {
    public static final String FORMAT_ISO = "%y%-%m%-%dom%";
    public static final String FORMAT_DAYTIME_WITHOUT_SECONDS = "%y%-%m%-%dom% %h%:%min%";
    public static final String FORMAT_HOURS_MINUTES = "%h%:%min%";

    private static String formatKey(DayTime dayTime, String key) {
        Day day = dayTime.getDay();
        if (key.equals("")) {
            return "%";
        }
        if (key.equals("y")) {
            return "" + day.getYear();
        }
        if (key.equals("y_s")) {
            String tmp = day.getYear().toString();
            return tmp.substring(tmp.length() - 2);
        }
        if (key.equals("m")) {
            return Padding.padLeft((String)("" + day.getMonth().getIndexWithinYear()), (char)'0', (int)2);
        }
        if (key.equals("m_s")) {
            return "" + day.getMonth().getIndexWithinYear();
        }
        if (key.equals("dom")) {
            return Padding.padLeft((String)("" + day.getIndexWithinMonth()), (char)'0', (int)2);
        }
        if (key.equals("dom_s")) {
            return "" + day.getIndexWithinMonth();
        }
        if (key.equals("w")) {
            return Padding.padLeft((String)("" + day.getWeek().getIndexWithinYear()), (char)'0', (int)2);
        }
        if (key.equals("h")) {
            return Padding.padLeft((String)("" + dayTime.getHour()), (char)'0', (int)2);
        }
        if (key.equals("h_s")) {
            return "" + dayTime.getHour();
        }
        if (key.equals("min")) {
            return Padding.padLeft((String)("" + dayTime.getMinute()), (char)'0', (int)2);
        }
        if (key.equals("min_s")) {
            return "" + dayTime.getMinute();
        }
        if (key.equals("sec")) {
            return Padding.padLeft((String)("" + dayTime.getSecond()), (char)'0', (int)2);
        }
        if (key.equals("sec_s")) {
            return "" + dayTime.getSecond();
        }
        throw new IllegalArgumentException("Unknown format pattern key '" + key + "'.");
    }

    public static String format(Date date, String pattern) {
        return DateUtils.format(new DayTime(date), pattern);
    }

    public static String format(Day day, String pattern) {
        return DateUtils.format(new DayTime(day, 0, 0, 0), pattern);
    }

    public static String format(DayTime dayTime, String pattern) {
        Object[] tmp = pattern.split("%");
        int n = tmp.length;
        for (int i = 1; i < n; i += 2) {
            tmp[i] = DateUtils.formatKey(dayTime, (String)tmp[i]);
        }
        return Imploder.implode((Object[])tmp, (String)"");
    }

    public static Day parseDate(String dateString) {
        return new DayParser(dateString).parse().orElse(null);
    }
}

