/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.core.clock.CurrentClock;
import com.softicar.platform.common.date.CommonDateI18n;
import com.softicar.platform.common.date.DateFormat;
import com.softicar.platform.common.date.DateItem;
import com.softicar.platform.common.date.DateUtils;
import com.softicar.platform.common.date.DayTime;
import com.softicar.platform.common.date.ISOCalendar;
import com.softicar.platform.common.date.Month;
import com.softicar.platform.common.date.Week;
import com.softicar.platform.common.date.Weekday;
import com.softicar.platform.common.date.Year;
import com.softicar.platform.common.string.Padding;
import java.util.Calendar;
import java.util.Date;

public final class Day
extends DateItem<Day> {
    private final int m_index;
    private static final int DAY_INDEX_1970 = 719528;

    public static Day get(int index) {
        return new Day(index);
    }

    @Override
    public int getAbsoluteIndex() {
        return this.m_index;
    }

    @Override
    public Day getRelative(int distance) {
        return Day.get(this.m_index + distance);
    }

    public Year getYear() {
        return Year.get(ISOCalendar.getYearWithDay(this.m_index));
    }

    public int getIndexWithinYear() {
        return ISOCalendar.getDayIndexWithinYear(this.m_index);
    }

    public Month getMonth() {
        return Month.get(ISOCalendar.getMonthWithDay(this.m_index));
    }

    public int getIndexWithinMonth() {
        return ISOCalendar.getDayIndexWithinMonth(this.m_index);
    }

    public Week getWeek() {
        return Week.get(ISOCalendar.getWeekWithDay(this.m_index));
    }

    public int getIndexWithinWeek() {
        return ISOCalendar.getDayIndexWithinWeek(this.m_index);
    }

    public Day getNextWeekDay(Weekday targetWeekDay) {
        Day targetDay = (Day)new Day(this.m_index).getNext();
        while (!targetDay.getWeekday().equals((Object)targetWeekDay)) {
            targetDay = (Day)targetDay.getNext();
        }
        return targetDay;
    }

    public Weekday getWeekday() {
        return Weekday.get(this.getIndexWithinWeek());
    }

    public boolean isMonday() {
        return this.getWeek().getMonday().equals(this);
    }

    public boolean isTuesday() {
        return this.getWeek().getTuesday().equals(this);
    }

    public boolean isWednesday() {
        return this.getWeek().getWednesday().equals(this);
    }

    public boolean isThursday() {
        return this.getWeek().getThursday().equals(this);
    }

    public boolean isFriday() {
        return this.getWeek().getFriday().equals(this);
    }

    public boolean isSaturday() {
        return this.getWeek().getSaturday().equals(this);
    }

    public boolean isSunday() {
        return this.getWeek().getSunday().equals(this);
    }

    public int getIndexSince1970() {
        return this.m_index - 719528;
    }

    public static Day get1970() {
        return new Day(719528);
    }

    public static Day fromYMD(int year, int month, int day) {
        int absoluteMonth = ISOCalendar.getMonthOfYear(year, month);
        int absoluteDay = ISOCalendar.getDayOfMonth(absoluteMonth, day);
        return Day.get(absoluteDay);
    }

    public static Day fromYMD(Year year, int month, int day) {
        return Day.fromYMD(year.getAbsoluteIndex(), month, day);
    }

    public static Day fromMillis(long millis) {
        Calendar cal = ISOCalendar.getNewCalendar();
        cal.setTimeInMillis(millis);
        return Day.fromYMD(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public static Day fromDate(Date date) {
        if (date != null) {
            return Day.fromMillis(date.getTime());
        }
        return null;
    }

    public static Day parse(DateFormat format, String text) {
        return format.parseDay(text);
    }

    public static Day today() {
        return Day.fromMillis(CurrentClock.get().millis());
    }

    public long toMillis() {
        Calendar cal = ISOCalendar.getNewCalendar();
        cal.set(1, this.getYear().getAbsoluteIndex());
        cal.set(2, this.getMonth().getIndexWithinYear() - 1);
        cal.set(5, this.getIndexWithinMonth());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public DayTime getBegin() {
        return new DayTime(this, 0, 0, 0);
    }

    public DayTime getEnd() {
        return new DayTime(this, 23, 59, 59);
    }

    public DayTime toDayTime() {
        return new DayTime(this);
    }

    public DayTime toDayTime(int seconds) {
        return DayTime.fromDayAndSeconds(this, seconds);
    }

    public Date toDate() {
        return new Date(this.toMillis());
    }

    public String format(String formatString) {
        return DateUtils.format(this, formatString);
    }

    public final String toString() {
        return this.toISOString();
    }

    public final String toGermanString() {
        return String.format("%02d.%02d.%04d", this.getIndexWithinMonth(), this.getMonth().getIndexWithinYear(), this.getYear().getAbsoluteIndex());
    }

    public final String toISOString() {
        return String.format("%04d-%02d-%02d", this.getYear().getAbsoluteIndex(), this.getMonth().getIndexWithinYear(), this.getIndexWithinMonth());
    }

    public final String toDMString() {
        return String.format("%d.%d.", this.getIndexWithinMonth(), this.getMonth().getIndexWithinYear());
    }

    public final String toHumanString() {
        switch (Day.today().getDistance(this)) {
            case -2: {
                return CommonDateI18n._2_DAYS_AGO.toString();
            }
            case -1: {
                return CommonDateI18n.YESTERDAY.toString();
            }
            case 0: {
                return CommonDateI18n.TODAY.toString();
            }
            case 1: {
                return CommonDateI18n.TOMORROW.toString();
            }
        }
        return this.toString();
    }

    public final String toYYWWDString() {
        return this.getWeek().toYYWWString() + this.getIndexWithinWeek();
    }

    public final String toDDString() {
        return Padding.padLeft((String)("" + this.getIndexWithinMonth()), (char)'0', (int)2);
    }

    public final String toYYMMDDString() {
        return this.getMonth().toYYMMString() + this.toDDString();
    }

    private Day(int index) {
        this.m_index = index;
    }
}

