/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.core.utils.DevNull;
import com.softicar.platform.common.date.Day;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DayParser {
    private static final int BASE_YEAR = 2000;
    private static final String DOT = "\\.";
    private static final String MINUS = "-";
    private static final String NUMBER = "[0-9]+";
    private static final String SLASH = "/";
    private static final Collection<Format> FORMATS = Arrays.asList(new Format("\\.", 2, 1, 0), new Format("/", 2, 0, 1), new Format("-", 0, 1, 2));
    private final String text;

    public DayParser(String text) {
        this.text = text;
    }

    public Optional<Day> parse() {
        try {
            return FORMATS.stream().filter(format -> format.matches(this.text)).findFirst().map(format -> format.parse(this.text));
        }
        catch (NumberFormatException exception) {
            DevNull.swallow((Object)exception);
            return Optional.empty();
        }
    }

    private static class Format {
        private final String separator;
        private final int yearIndex;
        private final int monthIndex;
        private final int dayIndex;
        private final Collection<String> patterns;

        public Format(String separator, int yearIndex, int monthIndex, int dayIndex) {
            this.separator = separator;
            this.yearIndex = yearIndex;
            this.monthIndex = monthIndex;
            this.dayIndex = dayIndex;
            this.patterns = new ArrayList<String>();
            this.patterns.add(DayParser.NUMBER + separator + DayParser.NUMBER + separator + DayParser.NUMBER);
            if (yearIndex > monthIndex && yearIndex > dayIndex) {
                this.patterns.add(DayParser.NUMBER + separator + DayParser.NUMBER);
                this.patterns.add(DayParser.NUMBER + separator + DayParser.NUMBER + separator);
            }
        }

        public boolean matches(String text) {
            return this.patterns.stream().anyMatch(pattern -> text.matches((String)pattern));
        }

        public Day parse(String text) {
            List<Integer> elements = this.split(text, this.separator);
            int year = this.getYear(elements);
            int month = elements.get(this.monthIndex);
            int day = elements.get(this.dayIndex);
            return this.createDay(year, month, day);
        }

        private List<Integer> split(String text, String separator) {
            return Arrays.asList(text.split(separator)).stream().map(Integer::parseInt).collect(Collectors.toList());
        }

        private int getYear(List<Integer> elements) {
            return this.yearIndex < elements.size() ? elements.get(this.yearIndex).intValue() : Day.today().getYear().getAbsoluteIndex();
        }

        private Day createDay(int year, int month, int day) {
            return Day.fromYMD(this.rebaseAbbreviatedYear(year), month, day);
        }

        private int rebaseAbbreviatedYear(int year) {
            return year < 100 ? 2000 + year : year;
        }
    }
}

