/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.core.clock.CurrentClock;
import com.softicar.platform.common.date.DateUtils;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.Duration;
import com.softicar.platform.common.date.ISOCalendar;
import com.softicar.platform.common.date.Time;
import com.softicar.platform.common.string.Padding;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;

public class DayTime
implements Comparable<DayTime> {
    private static final int MAXIMUM_SECONDS = 86399;
    private Day day;
    private int secondsOfDay;

    public DayTime(Day day) {
        this.day = day;
        this.secondsOfDay = 0;
    }

    public DayTime(Day day, Time time) {
        this.day = day;
        this.secondsOfDay = time.getTimeInSeconds();
    }

    public DayTime(Day day, int hour, int minute, int second) {
        this.day = day;
        this.secondsOfDay = (hour * 60 + minute) * 60 + second;
    }

    public DayTime(Date date) {
        this.init(date);
    }

    private DayTime(Day day, int seconds) {
        this.day = day;
        this.secondsOfDay = seconds;
        if (seconds < 0 || seconds > 86399) {
            throw new IllegalArgumentException(String.format("Seconds must be in the range [0, %s].", 86399));
        }
    }

    private DayTime(long millis) {
        this.init(millis);
    }

    private void init(Date date) {
        Calendar cal = ISOCalendar.getNewCalendar();
        cal.setTime(date);
        this.init(cal);
    }

    private void init(long millis) {
        Calendar cal = ISOCalendar.getNewCalendar();
        cal.setTimeInMillis(millis);
        this.init(cal);
    }

    private void init(Calendar cal) {
        this.day = Day.fromYMD(cal.get(1), cal.get(2) + 1, cal.get(5));
        this.secondsOfDay = 3600 * cal.get(11) + 60 * cal.get(12) + cal.get(13);
    }

    public static DayTime fromDate(Date date) {
        return date != null ? new DayTime(date) : null;
    }

    public static DayTime fromInstant(Instant instant) {
        return instant != null ? DayTime.fromMillis(instant.toEpochMilli()) : null;
    }

    public static DayTime fromMillis(long millis) {
        return new DayTime(millis);
    }

    public static DayTime fromYMD_HMS(int year, int month, int day, int hour, int minute, int second) {
        return new DayTime(Day.fromYMD(year, month, day), hour, minute, second);
    }

    public static DayTime fromDayAndSeconds(Day day, int seconds) {
        return new DayTime(day, seconds);
    }

    public static DayTime get1970() {
        return new DayTime(Day.get1970());
    }

    public static DayTime now() {
        return new DayTime(CurrentClock.get().millis());
    }

    public static DayTime today() {
        return new DayTime(Day.today());
    }

    public static DayTime max(DayTime ... dayTimes) {
        return DayTime.max(Arrays.asList(dayTimes));
    }

    public static DayTime max(Collection<DayTime> dayTimes) {
        return dayTimes.stream().filter(Objects::nonNull).sorted(Comparator.reverseOrder()).findFirst().orElse(null);
    }

    public static DayTime min(DayTime ... dayTimes) {
        return DayTime.min(Arrays.asList(dayTimes));
    }

    public static DayTime min(Collection<DayTime> dayTimes) {
        return dayTimes.stream().filter(Objects::nonNull).sorted().findFirst().orElse(null);
    }

    public Day getDay() {
        return this.day;
    }

    public int getHour() {
        return this.secondsOfDay / 3600;
    }

    public int getMinute() {
        return this.secondsOfDay / 60 % 60;
    }

    public int getSecond() {
        return this.secondsOfDay % 60;
    }

    public Time getTime() {
        return new Time(this.secondsOfDay);
    }

    public int getSecondsOfDay() {
        return this.secondsOfDay;
    }

    @Override
    public int compareTo(DayTime other) {
        int dayCompare = this.day.compareTo(other.day);
        if (dayCompare != 0) {
            return dayCompare;
        }
        return this.secondsOfDay - other.secondsOfDay;
    }

    public boolean equals(Object object) {
        if (object instanceof DayTime) {
            DayTime other = (DayTime)object;
            return Objects.equals(this.day, other.day) && Objects.equals(this.secondsOfDay, other.secondsOfDay);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.day, this.secondsOfDay);
    }

    public boolean isAfter(DayTime other) {
        return this.compareTo(other) > 0;
    }

    public boolean isAfterOrEqual(DayTime other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isBefore(DayTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean isBeforeOrEqual(DayTime other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isBetween(DayTime first, DayTime last) {
        return this.isAfterOrEqual(first) && this.isBeforeOrEqual(last);
    }

    public Date toDate() {
        return new Date(this.toMillis());
    }

    public Instant toInstant() {
        return Instant.ofEpochMilli(this.toMillis());
    }

    public long toMillis() {
        Calendar cal = ISOCalendar.getNewCalendar();
        cal.clear();
        cal.set(1, this.getDay().getYear().getAbsoluteIndex());
        cal.set(2, this.getDay().getMonth().getIndexWithinYear() - 1);
        cal.set(5, this.getDay().getIndexWithinMonth());
        cal.set(11, this.getHour());
        cal.set(12, this.getMinute());
        cal.set(13, this.getSecond());
        return cal.getTimeInMillis();
    }

    public DayTime plusDays(int days) {
        return new DayTime(this.day.getRelative(days), this.secondsOfDay);
    }

    public DayTime minusDays(int days) {
        return this.plusDays(-days);
    }

    public Duration getDuration(DayTime other) {
        return new Duration(this, other);
    }

    public double minus(DayTime beginDayTime) {
        return (double)(this.toDate().getTime() - beginDayTime.toDate().getTime()) / 1000.0;
    }

    public DayTime getYesterday() {
        return this.plusDays(-1);
    }

    public DayTime getLastWeek() {
        return this.plusDays(-7);
    }

    public DayTime getTomorrow() {
        return this.plusDays(1);
    }

    public DayTime plusSecondsInUtc(double interval) {
        long time = this.toDate().getTime() + (long)(interval * 1000.0 + 0.5);
        return new DayTime(new Date(time));
    }

    public DayTime plusSeconds(double seconds) {
        return this.plusSeconds(Math.round(seconds));
    }

    public DayTime plusSeconds(long seconds) {
        if (seconds != 0L) {
            long tmp = (long)this.secondsOfDay + seconds;
            int time = (int)(tmp % 86400L);
            int days = (int)(tmp / 86400L);
            if (time < 0) {
                --days;
                time += 86400;
            }
            if (days != 0) {
                return new DayTime(this.day.getRelative(days), time);
            }
            return new DayTime(this.day, time);
        }
        return this;
    }

    public DayTime minusSeconds(double seconds) {
        return this.minusSeconds(Math.round(seconds));
    }

    public DayTime minusSeconds(long seconds) {
        return this.plusSeconds(-seconds);
    }

    public DayTime truncateSeconds() {
        return this.minusSeconds(this.getSecond());
    }

    public String format(String formatString) {
        return DateUtils.format(this, formatString);
    }

    public String getTimeAsString() {
        return Padding.padLeft((String)("" + this.getHour()), (char)'0', (int)2) + ":" + Padding.padLeft((String)("" + this.getMinute()), (char)'0', (int)2) + ":" + Padding.padLeft((String)("" + this.getSecond()), (char)'0', (int)2);
    }

    public String getTimeAsStringHM() {
        return Padding.padLeft((String)("" + this.getHour()), (char)'0', (int)2) + ":" + Padding.padLeft((String)("" + this.getMinute()), (char)'0', (int)2);
    }

    public String getTimeAsStringHHMM() {
        return Padding.padLeft((String)("" + this.getHour()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getMinute()), (char)'0', (int)2);
    }

    public String getTimeAsStringYYYYMMDD_HHMM() {
        return this.getDay().getYear().getAbsoluteIndex() + Padding.padLeft((String)("" + this.getDay().getMonth().getIndexWithinYear()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getDay().getIndexWithinMonth()), (char)'0', (int)2) + Padding.padLeft((String)("_" + this.getHour()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getMinute()), (char)'0', (int)2);
    }

    public String getTimeAsStringYYYYMMDDHHMM() {
        return this.getDay().getYear().getAbsoluteIndex() + Padding.padLeft((String)("" + this.getDay().getMonth().getIndexWithinYear()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getDay().getIndexWithinMonth()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getHour()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getMinute()), (char)'0', (int)2);
    }

    public String getTimeAsStringForEdiInterchange() {
        return this.getDay().getYear().toYYString() + Padding.padLeft((String)("" + this.getDay().getMonth().getIndexWithinYear()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getDay().getIndexWithinMonth()), (char)'0', (int)2) + Padding.padLeft((String)(":" + this.getHour()), (char)'0', (int)2) + Padding.padLeft((String)("" + this.getMinute()), (char)'0', (int)2);
    }

    public String toString() {
        return this.day + " " + this.getTimeAsString();
    }

    public String toHumanString() {
        return this.day.toHumanString() + " " + this.getTimeAsStringHM();
    }

    public String toGermanString() {
        return this.day.toGermanString() + " " + this.getTimeAsStringHM();
    }

    public String toStringHHMM(String separator) {
        return (Serializable)(this.getHour() < 10 ? "0" + this.getHour() : Integer.valueOf(this.getHour())) + separator + (Serializable)(this.getMinute() < 10 ? "0" + this.getMinute() : Integer.valueOf(this.getMinute()));
    }

    public String toStringYYYYMMDDHHMM() {
        return this.format("%y%%m%%dom%%h%%min%");
    }
}

