/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.core.exceptions.SofticarException;
import com.softicar.platform.common.date.DateFormat;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.DayTime;

public class DayTimeParser {
    private State m_state = State.OK;
    private DayTime m_dayTime;

    public DayTimeParser(String text, Format format) {
        if (text.length() != format.length()) {
            this.m_state = State.INVALID_LENGTH;
            return;
        }
        this.setDayTime(text, format);
    }

    private void setDayTime(String text, Format format) {
        switch (format) {
            case YYWWD: {
                Day day = DateFormat.YYWWD.parseDay(text);
                Integer hour = 0;
                Integer minute = 0;
                Integer second = 0;
                this.m_dayTime = new DayTime(day, hour, minute, second);
                break;
            }
            case YYMMDD: {
                this.setDayTime(text + "000000", Format.YYMMDDHHMMSS);
                break;
            }
            case YYYYMMDD: {
                this.setDayTime(text + "000000", Format.YYYYMMDDHHMMSS);
                break;
            }
            case YYMMDDHHMM: {
                this.setDayTime(text + "00", Format.YYMMDDHHMMSS);
                break;
            }
            case YYMMDDHHMMSS: {
                Day day = DateFormat.YYMMDD.parseDay(text.substring(0, 6));
                Integer hour = Integer.parseInt(text.substring(6, 8));
                Integer minute = Integer.parseInt(text.substring(8, 10));
                Integer second = Integer.parseInt(text.substring(10, 12));
                this.m_dayTime = new DayTime(day, hour, minute, second);
                break;
            }
            case YYYYMMDDHHMMSS: {
                Day day = DateFormat.YYYYMMDD.parseDay(text.substring(0, 8));
                Integer hour = Integer.parseInt(text.substring(8, 10));
                Integer minute = Integer.parseInt(text.substring(10, 12));
                Integer second = Integer.parseInt(text.substring(12, 14));
                this.m_dayTime = new DayTime(day, hour, minute, second);
                break;
            }
            case YYYYMMDDHHMM: {
                Day day = DateFormat.YYYYMMDD.parseDay(text.substring(0, 8));
                Integer hour = Integer.parseInt(text.substring(8, 10));
                Integer minute = Integer.parseInt(text.substring(10, 12));
                this.m_dayTime = new DayTime(day, hour, minute, 0);
                break;
            }
            case YYYY_MM_DD_HH_MM_SS: {
                text = text.replace("-", "").replace(":", "").replace(" ", "").replace("T", "");
                this.setDayTime(text, Format.YYYYMMDDHHMMSS);
                break;
            }
            case DD_MM_YYYY: {
                Day day = DateFormat.DD_MM_YYYY.parseDay(text);
                this.m_dayTime = new DayTime(day, 0, 0, 0);
                break;
            }
        }
    }

    public State getState() {
        return this.m_state;
    }

    public DayTime getDayTime() {
        return this.m_dayTime;
    }

    public static DayTime parse(String text, Format format) {
        DayTimeParser parser = new DayTimeParser(text, format);
        if (!parser.getState().equals((Object)State.OK)) {
            throw new SofticarException("Error while parsing date '%s': %s", new Object[]{text, parser.getState().toString()});
        }
        return parser.getDayTime();
    }

    public static enum State {
        OK,
        INVALID_LENGTH,
        INVALID_RANGE;

    }

    public static enum Format {
        YYWWD(5),
        YYMMDD(6),
        YYYYMMDD(8),
        YYMMDDHHMM(10),
        YYMMDDHHMMSS(12),
        YYYYMMDDHHMM(12),
        YYYYMMDDHHMMSS(14),
        YYYY_MM_DD_HH_MM_SS(19),
        DD_MM_YYYY(10);

        private final int m_length;

        public int length() {
            return this.m_length;
        }

        public DayTime parse(String text) {
            return DayTimeParser.parse(text, this);
        }

        private Format(int length) {
            this.m_length = length;
        }
    }
}

