/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.CommonDateI18n;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.DayTime;
import java.util.Objects;

public class Duration {
    private static final long HOURS_PER_DAY = 24L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long MINUTES_PER_DAY = 1440L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private final long totalSeconds;

    public Duration(DayTime begin, DayTime end) {
        this(Duration.toSeconds(end) - Duration.toSeconds(begin));
    }

    public Duration(long seconds) {
        this.totalSeconds = seconds;
    }

    public String toString() {
        int days = this.getDays();
        int hours = this.getHoursOfDay();
        int minutes = this.getMinutesOfHour();
        int seconds = this.getSecondsOfMinute();
        if (days != 0) {
            return CommonDateI18n.ARG1D_ARG2H_ARG3MIN_ARG4S.toDisplay((Object)days, (Object)hours, (Object)minutes, (Object)seconds).toString();
        }
        if (hours != 0) {
            return CommonDateI18n.ARG1H_ARG2MIN_ARG3S.toDisplay((Object)hours, (Object)minutes, (Object)seconds).toString();
        }
        if (minutes != 0) {
            return CommonDateI18n.ARG1MIN_ARG2S.toDisplay((Object)minutes, (Object)seconds).toString();
        }
        return CommonDateI18n.ARG1_SECONDS.toDisplay((Object)seconds).toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Duration) {
            return this.totalSeconds == ((Duration)object).totalSeconds;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.totalSeconds);
    }

    public int getDays() {
        return (int)(this.totalSeconds / 86400L);
    }

    public int getHoursOfDay() {
        return (int)(this.totalSeconds % 86400L / 3600L);
    }

    public int getMinutesOfHour() {
        return (int)(this.totalSeconds % 3600L / 60L);
    }

    public int getSecondsOfMinute() {
        return (int)(this.totalSeconds % 60L);
    }

    public long getTotalSeconds() {
        return this.totalSeconds;
    }

    public Duration clamp() {
        return this.totalSeconds < 0L ? new Duration(0L) : this;
    }

    private static long toSeconds(DayTime dayTime) {
        Day day = dayTime.getDay();
        return (long)day.getAbsoluteIndex() * 86400L + (long)dayTime.getSecondsOfDay();
    }
}

