/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.MonthName;
import com.softicar.platform.common.date.Weekday;
import com.softicar.platform.common.date.YearType;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISOCalendar {
    public static final int SECONDS_PER_DAY = 86400;
    public static final Locale LOCALE = Locale.GERMANY;
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("Europe/Berlin");
    private static final int MONTHS_PER_YEAR = 12;
    private static final int DAYS_PER_WEEK = 7;
    private static final int FIRST_MONDAY = 2;
    private static final MonthName[] DAY_TO_MONTH_MAP1;
    private static final MonthName[] DAY_TO_MONTH_MAP2;

    public static void setDefaultTimeZone() {
        TimeZone.setDefault(TIME_ZONE);
    }

    public static int getYearWithMonth(int month) {
        return month / 12;
    }

    public static int getYearWithWeek(int week) {
        int thursday = ISOCalendar.getFirstDayOfWeek(week) + Weekday.THURSDAY.getIndex() - 1;
        return ISOCalendar.getYearWithDay(thursday);
    }

    public static int getYearWithDay(int day) {
        int year = day / 365;
        while (day < ISOCalendar.getFirstDayOfYear(year)) {
            --year;
        }
        return year;
    }

    public static int getMonthWithWeek(int week) {
        int thursday = ISOCalendar.getFirstDayOfWeek(week) + Weekday.THURSDAY.getIndex() - 1;
        return ISOCalendar.getMonthWithDay(thursday);
    }

    public static int getFirstDayOfYear(int year) {
        return 365 * year + (year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400;
    }

    public static int getFirstWeekOfYear(int year) {
        int firstDay = ISOCalendar.getFirstDayOfYear(year);
        int week = ISOCalendar.getWeekWithDay(firstDay);
        return ISOCalendar.getYearWithWeek(week) == year ? week : week + 1;
    }

    public static int getFirstDayOfMonth(int month) {
        int indexWithinYear = ISOCalendar.getMonthIndexWithinYear(month);
        MonthName monthName = MonthName.get(indexWithinYear);
        int year = ISOCalendar.getYearWithMonth(month);
        YearType yearType = YearType.getForYear(year);
        return ISOCalendar.getFirstDayOfYear(year) + monthName.getStart(yearType) - 1;
    }

    public static int getFirstWeekOfMonth(int month) {
        int firstDay = ISOCalendar.getFirstDayOfMonth(month);
        int week = ISOCalendar.getWeekWithDay(firstDay);
        return ISOCalendar.getMonthWithWeek(week) == month ? week : week + 1;
    }

    public static int getFirstDayOfWeek(int week) {
        return week * 7 + 2;
    }

    public static int[] getFirstAndLastDayOfYear(int year) {
        int[] days;
        YearType yearType = YearType.getForYear(year);
        days = new int[]{ISOCalendar.getFirstDayOfYear(year), days[0] + yearType.getDayCount() - 1};
        return days;
    }

    public static int[] getFirstAndLastWeekOfYear(int year) {
        int[] weeks = new int[]{ISOCalendar.getFirstWeekOfYear(year), ISOCalendar.getFirstWeekOfYear(year + 1) - 1};
        return weeks;
    }

    public static int[] getFirstAndLastDayOfMonth(int month) {
        int[] result;
        int indexWithinYear = ISOCalendar.getMonthIndexWithinYear(month);
        MonthName monthName = MonthName.get(indexWithinYear);
        int year = ISOCalendar.getYearWithMonth(month);
        YearType yearType = YearType.getForYear(year);
        result = new int[]{ISOCalendar.getFirstDayOfYear(year) + monthName.getStart(yearType) - 1, result[0] + monthName.getDayCount(yearType) - 1};
        return result;
    }

    public static int[] getFirstAndLastWeekOfMonth(int month) {
        int[] weeks = new int[]{ISOCalendar.getFirstWeekOfMonth(month), ISOCalendar.getFirstWeekOfMonth(month + 1) - 1};
        return weeks;
    }

    public static int[] getFirstAndLastDayOfWeek(int week) {
        int[] days;
        days = new int[]{ISOCalendar.getFirstDayOfWeek(week), days[0] + 7 - 1};
        return days;
    }

    public static int getDayIndexWithinYear(int day) {
        int year = ISOCalendar.getYearWithDay(day);
        int firstDay = ISOCalendar.getFirstDayOfYear(year);
        return day - firstDay + 1;
    }

    public static int getDayOfYear(int year, int day) {
        return ISOCalendar.getFirstDayOfYear(year) + day - 1;
    }

    public static int getDayIndexWithinMonth(int day) {
        int month = ISOCalendar.getMonthWithDay(day);
        int firstDay = ISOCalendar.getFirstDayOfMonth(month);
        return day - firstDay + 1;
    }

    public static int getDayIndexWithinWeek(int day) {
        int result = (day - 2) % 7;
        if (result < 0) {
            result += 7;
        }
        return result + 1;
    }

    public static int getDayOfMonth(int month, int day) {
        return ISOCalendar.getFirstDayOfMonth(month) + day - 1;
    }

    public static int getMonthWithDay(int day) {
        int year = ISOCalendar.getYearWithDay(day);
        YearType yearType = YearType.getForYear(year);
        int indexWithYear = ISOCalendar.getDayIndexWithinYear(day);
        MonthName monthName = yearType == YearType.NON_LEAP ? DAY_TO_MONTH_MAP1[indexWithYear - 1] : DAY_TO_MONTH_MAP2[indexWithYear - 1];
        return ISOCalendar.getMonthOfYear(year, monthName.getIndex());
    }

    public static int getMonthIndexWithinYear(int month) {
        return month % 12 + 1;
    }

    public static int getMonthOfYear(int year, int month) {
        return year * 12 + month - 1;
    }

    public static int getWeekWithDay(int day) {
        if (day >= 2) {
            return (day - 2) / 7;
        }
        return (day - 2 + 1) / 7 - 1;
    }

    public static int getWeekIndexWithinYear(int week) {
        int year = ISOCalendar.getYearWithWeek(week);
        int firstWeek = ISOCalendar.getFirstWeekOfYear(year);
        return week - firstWeek + 1;
    }

    public static int getWeekIndexWithinMonth(int week) {
        int month = ISOCalendar.getMonthWithWeek(week);
        int firstWeek = ISOCalendar.getFirstWeekOfMonth(month);
        return week - firstWeek + 1;
    }

    public static Calendar getNewCalendar() {
        return Calendar.getInstance(TIME_ZONE, LOCALE);
    }

    public static boolean isValidYMD(int year, int month, int day) {
        if (day < 1 || month < 1 || month > 12) {
            return false;
        }
        YearType yearType = YearType.getForYear(year);
        MonthName monthName = MonthName.get(month);
        return day <= monthName.getDayCount(yearType);
    }

    static {
        ISOCalendar.setDefaultTimeZone();
        DAY_TO_MONTH_MAP1 = new MonthName[365];
        DAY_TO_MONTH_MAP2 = new MonthName[366];
        int i1 = 0;
        int i2 = 0;
        for (MonthName monthName : MonthName.values()) {
            int j;
            for (j = 0; j != monthName.getDayCount(YearType.NON_LEAP); ++j) {
                ISOCalendar.DAY_TO_MONTH_MAP1[i1++] = monthName;
            }
            for (j = 0; j != monthName.getDayCount(YearType.LEAP); ++j) {
                ISOCalendar.DAY_TO_MONTH_MAP2[i2++] = monthName;
            }
        }
    }
}

