/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.DateItem;
import com.softicar.platform.common.date.DateItemRange;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.ISOCalendar;
import com.softicar.platform.common.date.MonthName;
import com.softicar.platform.common.date.Week;
import com.softicar.platform.common.date.Year;
import com.softicar.platform.common.string.Padding;

public final class Month
extends DateItem<Month> {
    private final int m_index;

    public static Month get(int index) {
        return new Month(index);
    }

    @Override
    public int getAbsoluteIndex() {
        return this.m_index;
    }

    @Override
    public Month getRelative(int distance) {
        return Month.get(this.m_index + distance);
    }

    public Year getYear() {
        return Year.get(ISOCalendar.getYearWithMonth(this.m_index));
    }

    public int getIndexWithinYear() {
        return ISOCalendar.getMonthIndexWithinYear(this.m_index);
    }

    public DateItemRange<Week> getWeeks() {
        int[] weeks = ISOCalendar.getFirstAndLastWeekOfMonth(this.m_index);
        return new DateItemRange<Week>(Week.get(weeks[0]), Week.get(weeks[1]));
    }

    public DateItemRange<Day> getDays() {
        int[] days = ISOCalendar.getFirstAndLastDayOfMonth(this.m_index);
        return new DateItemRange<Day>(Day.get(days[0]), Day.get(days[1]));
    }

    public Day getFirstDayInMonth() {
        int day = ISOCalendar.getFirstDayOfMonth(this.m_index);
        return Day.get(day);
    }

    public Day getLastDayInMonth() {
        int[] days = ISOCalendar.getFirstAndLastDayOfMonth(this.m_index);
        return Day.get(days[1]);
    }

    public MonthName getName() {
        return MonthName.get(this.getIndexWithinYear());
    }

    public String toString() {
        return this.getYear() + "-" + Padding.padLeft((String)("" + this.getIndexWithinYear()), (char)'0', (int)2);
    }

    public String toMMString() {
        if (this.getIndexWithinYear() < 10) {
            return "0" + this.getIndexWithinYear();
        }
        return "" + this.getIndexWithinYear();
    }

    public String toYYMMString() {
        return this.getYear().toYYString() + this.toMMString();
    }

    private Month(int index) {
        this.m_index = index;
    }
}

