/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.i18n.IDisplayable;
import com.softicar.platform.common.date.CommonDateI18n;
import com.softicar.platform.common.date.YearType;

public enum MonthName implements IDisplayable
{
    JANUARY((IDisplayString)CommonDateI18n.JANUARY, 31, 1),
    FEBRUARY((IDisplayString)CommonDateI18n.FEBRUARY, 28, 32),
    MARCH((IDisplayString)CommonDateI18n.MARCH, 31, 60),
    APRIL((IDisplayString)CommonDateI18n.APRIL, 30, 91),
    MAY((IDisplayString)CommonDateI18n.MAY, 31, 121),
    JUNE((IDisplayString)CommonDateI18n.JUNE, 30, 152),
    JULY((IDisplayString)CommonDateI18n.JULY, 31, 182),
    AUGUST((IDisplayString)CommonDateI18n.AUGUST, 31, 213),
    SEPTEMBER((IDisplayString)CommonDateI18n.SEPTEMBER, 30, 244),
    OCTOBER((IDisplayString)CommonDateI18n.OCTOBER, 31, 274),
    NOVEMBER((IDisplayString)CommonDateI18n.NOVEMBER, 30, 305),
    DECEMBER((IDisplayString)CommonDateI18n.DECEMBER, 31, 335);

    private final IDisplayString name;
    private final int size;
    private final int start;

    private MonthName(IDisplayString name, int size, int start) {
        this.name = name;
        this.size = size;
        this.start = start;
    }

    public int getIndex() {
        return this.ordinal() + 1;
    }

    public IDisplayString toDisplay() {
        return this.name;
    }

    public int getDayCount(YearType yearType) {
        if (yearType == YearType.NON_LEAP) {
            return this.size;
        }
        return this != FEBRUARY ? this.size : this.size + 1;
    }

    public int getStart(YearType yearType) {
        if (yearType == YearType.NON_LEAP) {
            return this.start;
        }
        return this.compareTo(MARCH) < 0 ? this.start : this.start + 1;
    }

    public MonthName getNext() {
        return MonthName.values()[(this.ordinal() + 1) % 12];
    }

    public MonthName getPrevious() {
        return MonthName.values()[(this.ordinal() + 11) % 12];
    }

    public MonthName getRelative(int i) {
        return MonthName.values()[(this.ordinal() + i) % 12];
    }

    public static MonthName get(int index) {
        return MonthName.values()[index - 1];
    }
}

