/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.DayTime;
import com.softicar.platform.common.date.Month;
import com.softicar.platform.common.date.Week;
import com.softicar.platform.common.date.Year;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class Period
implements Comparable<Period> {
    public static final Period DEFAULT = new Period();
    private final Timestamp begin;
    private final Timestamp end;

    public Period() {
        this(0L, 0L);
    }

    public Period(long begin, long end) {
        if (begin > end) {
            throw new IllegalArgumentException(String.format("Begin of period must be less or equal to end but was (%s, %s).", DayTime.fromMillis(begin), DayTime.fromMillis(end)));
        }
        this.begin = new Timestamp(begin);
        this.end = new Timestamp(end);
    }

    public Period(Day day) {
        this(day, day);
    }

    public Period(Day firstDay, Day lastDay) {
        this(firstDay.getBegin(), lastDay.getEnd());
    }

    public Period(DayTime point) {
        this(point, point);
    }

    public Period(DayTime begin, DayTime end) {
        this(begin.toDate(), end.toDate());
    }

    public Period(Date point) {
        this(point, point);
    }

    public Period(Date begin, Date end) {
        this(begin.getTime(), end.getTime());
    }

    public Period(Timestamp begin, Timestamp end) {
        this(begin.getTime(), end.getTime());
    }

    public Period(Week week) {
        this(week, week);
    }

    public Period(Week firstWeek, Week lastWeek) {
        this(firstWeek.getMonday(), lastWeek.getSunday());
    }

    public Period(Month month) {
        this(month.getDays().getFirst(), month.getDays().getLast());
    }

    public Period(Year year) {
        this(year.getDays().getFirst(), year.getDays().getLast());
    }

    public Timestamp getBegin() {
        return this.begin;
    }

    public Timestamp getEnd() {
        return this.end;
    }

    public DayTime getBeginDayTime() {
        return new DayTime(this.getBegin());
    }

    public DayTime getEndDayTime() {
        return new DayTime(this.getEnd());
    }

    public boolean isPointInTime() {
        return this.begin.equals(this.end);
    }

    public long getSize() {
        return this.end.getTime() - this.begin.getTime();
    }

    public double getDuration() {
        return (double)this.getSize() / 1000.0;
    }

    public Long getDurationInDays() {
        return Math.round(this.getDuration() / 60.0 / 60.0 / 24.0);
    }

    public DayTime getDurationDayTime() {
        return DayTime.fromDayAndSeconds(Day.get1970(), (int)Math.round(this.getDuration()));
    }

    public boolean equals(Object object) {
        if (object instanceof Period) {
            return this.compareTo((Period)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end);
    }

    public List<Day> getContainedDays() {
        ArrayList<Day> days = new ArrayList<Day>();
        Day begin = this.getBeginDayTime().getDay();
        Day end = this.getEndDayTime().getDay();
        Day day = begin;
        while (day.compareTo(end) <= 0) {
            days.add(day);
            day = (Day)day.getNext();
        }
        return days;
    }

    public Set<Period> getContainedWeeksAsPeriods() {
        TreeSet<Period> weeks = new TreeSet<Period>();
        for (Period p : this.getContainedDaysAsPeriods()) {
            weeks.add(new Period(p.getBeginDayTime().getDay().getWeek()));
        }
        return weeks;
    }

    public Set<Week> getContainedWeeks() {
        TreeSet<Week> weeks = new TreeSet<Week>();
        for (Period p : this.getContainedWeeksAsPeriods()) {
            weeks.add(Week.fromPeriod(p));
        }
        return weeks;
    }

    public Vector<Period> getContainedDaysAsPeriods() {
        Vector<Period> days = new Vector<Period>();
        Day begin = this.getBeginDayTime().getDay();
        Day end = this.getEndDayTime().getDay();
        Day day = begin;
        while (day.compareTo(end) <= 0) {
            days.add(new Period(new DayTime(day, 0, 0, 0), new DayTime(day, 23, 59, 59)));
            day = (Day)day.getNext();
        }
        return days;
    }

    public boolean equals(Period p) {
        if (p == null) {
            return false;
        }
        return this.begin.equals(p.begin) && this.end.equals(p.end);
    }

    @Override
    public int compareTo(Period p) {
        int b = this.begin.compareTo(p.begin);
        return b != 0 ? b : this.end.compareTo(p.end);
    }

    public static Period min(Period a, Period b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static Period max(Period a, Period b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    public String toString() {
        return "(" + this.begin + " -> " + this.end + ")";
    }

    public boolean contains(Period p) {
        return this.getBeginDayTime().compareTo(p.getBeginDayTime()) <= 0 && this.getEndDayTime().compareTo(p.getEndDayTime()) >= 0;
    }

    public boolean intersects(Period p) {
        return this.getBeginDayTime().compareTo(p.getBeginDayTime()) <= 0 && this.getEndDayTime().compareTo(p.getBeginDayTime()) >= 0 || this.getBeginDayTime().compareTo(p.getEndDayTime()) >= 0 && this.getBeginDayTime().compareTo(p.getEndDayTime()) <= 0;
    }

    public boolean isOneDay() {
        return this.getBeginDayTime().getDay().equals(this.getEndDayTime().getDay());
    }

    public boolean isWeek() {
        Week beginWeek = this.getBeginDayTime().getDay().getWeek();
        return beginWeek.getMonday().equals(this.getBeginDayTime().getDay()) && beginWeek.getSunday().equals(this.getEndDayTime().getDay());
    }

    public Period getModifiedPeriodByWeeks(int weeks) {
        DayTime begin = this.getBeginDayTime();
        DayTime end = this.getEndDayTime();
        begin = begin.plusDays(weeks * 7);
        end = end.plusDays(weeks * 7);
        Period modifiedPeriod = new Period(begin, end);
        return modifiedPeriod;
    }

    public Period getModifiedPeriodByDays(int days) {
        DayTime begin = this.getBeginDayTime();
        DayTime end = this.getEndDayTime();
        begin = begin.plusDays(days);
        end = end.plusDays(days);
        Period modifiedPeriod = new Period(begin, end);
        return modifiedPeriod;
    }

    public String getHumanString() {
        return this.getBeginDayTime().getDay().toString() + " -- " + this.getEndDayTime().getDay().toString();
    }

    public Period getIntersection(Period p) {
        long a = this.getBegin().getTime();
        long b = this.getEnd().getTime();
        long c = p.getBegin().getTime();
        long d = p.getEnd().getTime();
        if (c <= a && b <= d) {
            return new Period(a, b);
        }
        if (a <= c && d <= b) {
            return new Period(c, d);
        }
        if (c <= b && b <= d) {
            return new Period(c, b);
        }
        if (c <= a && a <= d) {
            return new Period(a, d);
        }
        if (a <= c && d <= b) {
            return new Period(c, d);
        }
        if (c <= a && b <= d) {
            return new Period(a, b);
        }
        if (b == c) {
            return new Period(b, b);
        }
        if (a == d) {
            return new Period(a, a);
        }
        return null;
    }

    public static boolean overlap(Period periodOne, Period periodTwo) {
        return Period.overlap(periodOne, periodTwo, 0L);
    }

    public static boolean overlap(Period periodOne, Period periodTwo, long milliseconds) {
        long a = periodOne.getBegin().getTime();
        long b = periodOne.getEnd().getTime();
        long c = periodTwo.getBegin().getTime();
        long d = periodTwo.getEnd().getTime();
        return b >= c + milliseconds && a <= d - milliseconds;
    }
}

