/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import java.util.Objects;

public class Time
implements Comparable<Time> {
    private static final int MAXIMUM_SECONDS_PER_DAY = 86400;
    private final int time;

    public Time() {
        this(0);
    }

    public Time(int hour, int minute, int second) {
        if (hour < 0 || hour >= 24) {
            throw new IllegalArgumentException(String.format("Illegal value %s for hour. Must be in the range [0, 23].", hour));
        }
        if (minute < 0 || minute >= 60) {
            throw new IllegalArgumentException(String.format("Illegal value %s for minute. Must be in the range [0, 59].", minute));
        }
        if (second < 0 || second >= 60) {
            throw new IllegalArgumentException(String.format("Illegal value %s for second. Must be in the range [0, 59].", second));
        }
        this.time = hour * 3600 + minute * 60 + second;
    }

    public Time(int seconds) {
        if (seconds < 0 || seconds >= 86400) {
            throw new IllegalArgumentException(String.format("Illegal value %s for seconds of day. Must be in the range [0, %s].", seconds, 86399));
        }
        this.time = seconds;
    }

    public static Time parseTime(String timeString) {
        String[] parts = timeString.split(":");
        if (parts.length == 3) {
            return new Time(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        throw new IllegalArgumentException(String.format("Illegal time string '%s'. Expected to have 3 parts separated by colon.", timeString));
    }

    public int getTimeInSeconds() {
        return this.time;
    }

    public int getHour() {
        return this.time / 3600;
    }

    public int getMinute() {
        return this.time / 60 % 60;
    }

    public int getSecond() {
        return this.time % 60;
    }

    public boolean equals(Object object) {
        if (object instanceof Time) {
            return this.time == ((Time)object).time;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.time);
    }

    public String toString() {
        return this.toIsoFormat();
    }

    public String toIsoFormat() {
        return String.format("%02d:%02d:%02d", this.getHour(), this.getMinute(), this.getSecond());
    }

    @Override
    public int compareTo(Time other) {
        return Integer.compare(this.time, other.time);
    }
}

