/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import com.softicar.platform.common.date.DateItem;
import com.softicar.platform.common.date.DateItemRange;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.ISOCalendar;
import com.softicar.platform.common.date.Month;
import com.softicar.platform.common.date.Period;
import com.softicar.platform.common.date.Weekday;
import com.softicar.platform.common.date.Year;
import com.softicar.platform.common.string.Padding;

public final class Week
extends DateItem<Week> {
    private final int m_index;

    public static Week get(int index) {
        return new Week(index);
    }

    @Override
    public int getAbsoluteIndex() {
        return this.m_index;
    }

    @Override
    public Week getRelative(int distance) {
        return Week.get(this.m_index + distance);
    }

    public static Week getCurrentWeek() {
        return Day.today().getWeek();
    }

    public Year getYear() {
        return Year.get(ISOCalendar.getYearWithWeek(this.m_index));
    }

    public int getIndexWithinYear() {
        return ISOCalendar.getWeekIndexWithinYear(this.m_index);
    }

    public Month getMonth() {
        return Month.get(ISOCalendar.getMonthWithWeek(this.m_index));
    }

    public int getIndexWithinMonth() {
        return ISOCalendar.getWeekIndexWithinMonth(this.m_index);
    }

    public DateItemRange<Day> getDays() {
        int[] days = ISOCalendar.getFirstAndLastDayOfWeek(this.m_index);
        return new DateItemRange<Day>(Day.get(days[0]), Day.get(days[1]));
    }

    public Day getDay(Weekday weekday) {
        return this.getDays().get(weekday.getIndex());
    }

    public Day getMonday() {
        return this.getDay(Weekday.MONDAY);
    }

    public Day getTuesday() {
        return this.getDay(Weekday.TUESDAY);
    }

    public Day getWednesday() {
        return this.getDay(Weekday.WEDNESDAY);
    }

    public Day getThursday() {
        return this.getDay(Weekday.THURSDAY);
    }

    public Day getFriday() {
        return this.getDay(Weekday.FRIDAY);
    }

    public Day getSaturday() {
        return this.getDay(Weekday.SATURDAY);
    }

    public Day getSunday() {
        return this.getDay(Weekday.SUNDAY);
    }

    public String toString() {
        return this.getYear() + "-W" + Padding.padLeft((String)("" + this.getIndexWithinYear()), (char)'0', (int)2);
    }

    public String toYYWWString() {
        return this.getYear().toYYString() + this.toWWString();
    }

    public String toYYYYWWString() {
        return this.getYear().toString() + this.toWWString();
    }

    public String toYYYYMinusWWString() {
        return this.getYear().toString() + "-" + this.toWWString();
    }

    public String toWWString() {
        String tmp = "" + this.getIndexWithinYear();
        return Padding.padLeft((String)tmp, (char)'0', (int)2);
    }

    public static Week fromPeriod(Period p) {
        Day beginDay = p.getBeginDayTime().getDay();
        Day endDay = p.getEndDayTime().getDay();
        Week week = beginDay.getWeek();
        if (!week.getMonday().equals(beginDay) || !week.getSunday().equals(endDay)) {
            throw new SofticarDeveloperException("Trying to convert the not week representating period '%s' into a week.", new Object[]{p.toString()});
        }
        return week;
    }

    public String getDisplayName() {
        return String.format("KW%d", this.getIndexWithinYear());
    }

    private Week(int index) {
        this.m_index = index;
    }
}

