/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.core.i18n.IDisplayString;
import com.softicar.platform.common.core.i18n.IDisplayable;
import com.softicar.platform.common.date.CommonDateI18n;
import com.softicar.platform.common.date.CommonWeekdayAbbreviationI18n;

public enum Weekday implements IDisplayable
{
    MONDAY((IDisplayString)CommonDateI18n.MONDAY, (IDisplayString)CommonWeekdayAbbreviationI18n.MO),
    TUESDAY((IDisplayString)CommonDateI18n.TUESDAY, (IDisplayString)CommonWeekdayAbbreviationI18n.TU),
    WEDNESDAY((IDisplayString)CommonDateI18n.WEDNESDAY, (IDisplayString)CommonWeekdayAbbreviationI18n.WE),
    THURSDAY((IDisplayString)CommonDateI18n.THURSDAY, (IDisplayString)CommonWeekdayAbbreviationI18n.TH),
    FRIDAY((IDisplayString)CommonDateI18n.FRIDAY, (IDisplayString)CommonWeekdayAbbreviationI18n.FR),
    SATURDAY((IDisplayString)CommonDateI18n.SATURDAY, (IDisplayString)CommonWeekdayAbbreviationI18n.SA),
    SUNDAY((IDisplayString)CommonDateI18n.SUNDAY, (IDisplayString)CommonWeekdayAbbreviationI18n.SU);

    private IDisplayString name;
    private IDisplayString shortName;

    private Weekday(IDisplayString name, IDisplayString shortName) {
        this.name = name;
        this.shortName = shortName;
    }

    public int getIndex() {
        return this.ordinal() + 1;
    }

    public IDisplayString toDisplay() {
        return this.name;
    }

    public IDisplayString toShortDisplay() {
        return this.shortName;
    }

    public int getDistance(Weekday other) {
        return other.getIndex() - this.getIndex();
    }

    public Weekday getNext() {
        return this == SUNDAY ? MONDAY : Weekday.get(this.getIndex() + 1);
    }

    public Weekday getPrevious() {
        return this == MONDAY ? SUNDAY : Weekday.get(this.getIndex() - 1);
    }

    public static Weekday get(int index) {
        return Weekday.values()[index - 1];
    }
}

