/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.date;

import com.softicar.platform.common.date.DateItem;
import com.softicar.platform.common.date.DateItemRange;
import com.softicar.platform.common.date.Day;
import com.softicar.platform.common.date.ISOCalendar;
import com.softicar.platform.common.date.Month;
import com.softicar.platform.common.date.MonthName;
import com.softicar.platform.common.date.Week;
import com.softicar.platform.common.date.YearType;
import com.softicar.platform.common.string.Padding;

public final class Year
extends DateItem<Year> {
    private final int m_index;

    public static Year get(int index) {
        return new Year(index);
    }

    public static Year thisYear() {
        return Day.today().getYear();
    }

    @Override
    public int getAbsoluteIndex() {
        return this.m_index;
    }

    @Override
    public Year getRelative(int distance) {
        return Year.get(this.m_index + distance);
    }

    public Month getMonth(MonthName monthName) {
        return Month.get(ISOCalendar.getMonthOfYear(this.m_index, monthName.getIndex()));
    }

    public DateItemRange<Month> getMonths() {
        return new DateItemRange<Month>(this.getMonth(MonthName.JANUARY), this.getMonth(MonthName.DECEMBER));
    }

    public DateItemRange<Week> getWeeks() {
        int[] weeks = ISOCalendar.getFirstAndLastWeekOfYear(this.m_index);
        return new DateItemRange<Week>(Week.get(weeks[0]), Week.get(weeks[1]));
    }

    public DateItemRange<Day> getDays() {
        int[] days = ISOCalendar.getFirstAndLastDayOfYear(this.m_index);
        return new DateItemRange<Day>(Day.get(days[0]), Day.get(days[1]));
    }

    public YearType getType() {
        return YearType.getForYear(this.m_index);
    }

    public String toString() {
        return Padding.padLeft((String)("" + this.m_index), (char)'0', (int)4);
    }

    public String toYYString() {
        String tmp = "" + this.getAbsoluteIndex() % 100;
        return Padding.padLeft((String)tmp, (char)'0', (int)2);
    }

    public static Integer getCurrentCentury() {
        return Integer.parseInt(new String("" + Year.thisYear().getAbsoluteIndex()).substring(0, 2));
    }

    public static Year getInCurrentCentury(int YY) {
        return Year.get(YY + Year.getCurrentCentury() * 100);
    }

    private Year(int index) {
        this.m_index = index;
    }
}

