/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.math;

public class Range<T extends Comparable<? super T>> {
    private T min;
    private T max;

    public Range() {
    }

    public Range(T value) {
        this(value, value);
    }

    public Range(T min, T max) {
        this.min = min;
        this.max = max;
    }

    public static <T extends Comparable<? super T>> Range<T> create(T min, T max) {
        return new Range<T>(min, max);
    }

    public boolean isValid() {
        return this.min != null;
    }

    public boolean isSingular() {
        return this.isValid() && this.min.compareTo(this.max) == 0;
    }

    public boolean hasSize() {
        return this.isValid() && this.min.compareTo(this.max) < 0;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean contains(T value) {
        return this.isValid() && value.compareTo(this.getMin()) >= 0 && value.compareTo(this.getMax()) <= 0;
    }

    public void add(T value) {
        if (this.isValid()) {
            if (value.compareTo(this.min) < 0) {
                this.min = value;
            } else if (value.compareTo(this.max) > 0) {
                this.max = value;
            }
        } else {
            this.max = value;
            this.min = this.max;
        }
    }

    public String toString() {
        if (this.hasSize()) {
            return "(" + this.min.toString() + " --> " + this.max.toString() + ")";
        }
        if (this.isSingular()) {
            return "(singular range: " + this.min.toString() + ")";
        }
        return "(invalid range)";
    }
}

