/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.math.arithmetic;

import com.softicar.platform.common.math.arithmetic.IArithmetic;

class FloatArithmetic
implements IArithmetic<Float> {
    private static final Float ZERO = Float.valueOf(0.0f);
    private static final Float ONE = Float.valueOf(1.0f);

    FloatArithmetic() {
    }

    @Override
    public Float getZero() {
        return ZERO;
    }

    @Override
    public Float getOne() {
        return ONE;
    }

    @Override
    public Float plus(Float left, Float right) {
        return Float.valueOf(left.floatValue() + right.floatValue());
    }

    @Override
    public Float minus(Float left, Float right) {
        return Float.valueOf(left.floatValue() - right.floatValue());
    }

    @Override
    public Float times(Float left, Float right) {
        return Float.valueOf(left.floatValue() * right.floatValue());
    }

    @Override
    public Float divided(Float left, Float right) {
        return Float.valueOf(left.floatValue() / right.floatValue());
    }

    @Override
    public Float negate(Float value) {
        return Float.valueOf(-value.floatValue());
    }

    @Override
    public int compare(Float left, Float right) {
        return Float.compare(left.floatValue(), right.floatValue());
    }
}

