/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.math.arithmetic;

import java.util.Comparator;
import java.util.Objects;

public interface IArithmetic<T>
extends Comparator<T> {
    public T getZero();

    public T getOne();

    public T plus(T var1, T var2);

    public T minus(T var1, T var2);

    public T times(T var1, T var2);

    public T divided(T var1, T var2);

    public T negate(T var1);

    default public boolean isZero(T value) {
        return Objects.equals(this.getZero(), value);
    }

    default public boolean isNotZero(T value) {
        return !Objects.equals(this.getZero(), value);
    }

    default public boolean isEqual(T left, T right) {
        return Objects.equals(left, right);
    }

    default public boolean isNotEqual(T left, T right) {
        return !Objects.equals(left, right);
    }

    default public boolean isLess(T left, T right) {
        return this.compare(left, right) < 0;
    }

    default public boolean isGreater(T left, T right) {
        return this.compare(left, right) > 0;
    }

    default public boolean isLessEqual(T left, T right) {
        return this.compare(left, right) <= 0;
    }

    default public boolean isGreaterEqual(T left, T right) {
        return this.compare(left, right) >= 0;
    }
}

