/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.math.integer;

public class IntegerBytes {
    public static byte[] toBytes_LE(int value) {
        byte[] bytes = new byte[4];
        IntegerBytes.toBytes_LE(value, bytes, 0);
        return bytes;
    }

    public static void toBytes_LE(int value, byte[] bytes, int index) {
        bytes[index + 0] = (byte)(value & 0xFF);
        bytes[index + 1] = (byte)((value >>= 8) & 0xFF);
        bytes[index + 2] = (byte)((value >>= 8) & 0xFF);
        bytes[index + 3] = (byte)((value >>= 8) & 0xFF);
    }

    public static byte[] toBytes_BE(int value) {
        byte[] bytes = new byte[4];
        IntegerBytes.toBytes_BE(value, bytes, 0);
        return bytes;
    }

    public static void toBytes_BE(int value, byte[] bytes, int index) {
        bytes[index + 3] = (byte)(value & 0xFF);
        bytes[index + 2] = (byte)((value >>= 8) & 0xFF);
        bytes[index + 1] = (byte)((value >>= 8) & 0xFF);
        bytes[index + 0] = (byte)((value >>= 8) & 0xFF);
    }

    public static int toInt_LE(byte[] bytes) {
        return IntegerBytes.toInt_LE(bytes, 0);
    }

    public static int toInt_LE(byte[] bytes, int index) {
        return IntegerBytes.toInt_LE(bytes[index + 0], bytes[index + 1], bytes[index + 2], bytes[index + 3]);
    }

    public static int toInt_BE(byte[] bytes) {
        return IntegerBytes.toInt_BE(bytes, 0);
    }

    public static int toInt_BE(byte[] bytes, int index) {
        return IntegerBytes.toInt_LE(bytes[index + 3], bytes[index + 2], bytes[index + 1], bytes[index + 0]);
    }

    public static int toInt_LE(byte b0, byte b1, byte b2, byte b3) {
        return 0x1000000 * IntegerBytes.getUnsignedByte(b3) + 65536 * IntegerBytes.getUnsignedByte(b2) + 256 * IntegerBytes.getUnsignedByte(b1) + 1 * IntegerBytes.getUnsignedByte(b0);
    }

    private static int getUnsignedByte(byte b) {
        return b < 0 ? 256 + b : b;
    }
}

