/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.math.range;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;

public class LongRange {
    private final long begin;
    private final long end;

    public LongRange(long begin, long end) {
        this.begin = begin;
        this.end = end;
    }

    public boolean isEmpty() {
        return this.begin == this.end;
    }

    public boolean isValid() {
        return this.begin <= this.end;
    }

    public LongRange getIntersection(LongRange other) {
        long begin = Math.max(this.begin, other.begin);
        long end = Math.min(this.end, other.end);
        return new LongRange(begin, end);
    }

    public long size() {
        if (!this.isValid()) {
            throw new SofticarDeveloperException("Tried to compute size of an invalid range.");
        }
        return this.end - this.begin;
    }
}

