/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.math.topology;

import com.softicar.platform.common.core.exceptions.SofticarDeveloperException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TopologicalSorter<T> {
    private final Map<T, Node> nodes = new HashMap<T, Node>();
    private List<T> sortedElements;

    public TopologicalSorter() {
    }

    public TopologicalSorter(Collection<T> elements) {
        this();
        this.addAll(elements);
    }

    public TopologicalSorter<T> add(T element) {
        this.nodes.put(element, new Node(element));
        return this;
    }

    public TopologicalSorter<T> addAll(Collection<T> elements) {
        elements.forEach(it -> this.nodes.put(it, new Node(it)));
        return this;
    }

    public TopologicalSorter<T> addEdge(T elementA, T elementB) {
        this.nodes.computeIfAbsent(elementA, x$0 -> new Node(x$0)).addTargetNode(this.nodes.computeIfAbsent(elementB, x$0 -> new Node(x$0)));
        return this;
    }

    public Collection<T> getSorted() {
        this.sortedElements = new ArrayList<T>();
        for (Node node : this.nodes.values()) {
            this.visit(node);
        }
        Collections.reverse(this.sortedElements);
        return this.sortedElements;
    }

    private void visit(Node node) {
        if (node.visited) {
            throw new CyclicTopologyException();
        }
        if (!node.done) {
            node.visited = true;
            for (Node targetNode : node.targetNodes) {
                this.visit(targetNode);
            }
            node.visited = false;
            node.done = true;
            this.sortedElements.add(node.element);
        }
    }

    private class Node {
        private final T element;
        private Collection<Node> targetNodes;
        private boolean visited;
        private boolean done;

        public Node(T element) {
            this.element = element;
            this.targetNodes = Collections.emptyList();
            this.visited = false;
            this.done = false;
        }

        public void addTargetNode(Node targetNode) {
            if (this.targetNodes.isEmpty()) {
                this.targetNodes = new ArrayList<Node>();
            }
            this.targetNodes.add(targetNode);
        }
    }

    public static class CyclicTopologyException
    extends SofticarDeveloperException {
        public CyclicTopologyException() {
            super("There are cycles in the dependeny graph.");
        }
    }
}

