/*
 * Decompiled with CFR 0.152.
 */
package com.softicar.platform.common.security.crypt;

import com.softicar.platform.common.security.crypt.BcryptAlgorithm;

public class Bcrypt {
    public static final int DEFAULT_NUMBER_OF_ROUNDS = 10;

    public static String encryptPassword(String password) {
        return Bcrypt.encryptPassword(password, 10);
    }

    public static String encryptPassword(String password, int rounds) {
        return BcryptAlgorithm.hashpw(password, BcryptAlgorithm.gensalt(rounds));
    }

    public static String encryptPassword(String password, String salt) {
        return BcryptAlgorithm.hashpw(password, salt);
    }

    public static boolean verifyPassword(String password, String encryptedPassword) {
        return BcryptAlgorithm.checkpw(password, encryptedPassword);
    }
}

